% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs_5yr_download.R
\name{get_area_groups}
\alias{get_area_groups}
\alias{get_area_groups.acs_5yr}
\title{Get area groups}
\usage{
get_area_groups(ac)

\method{get_area_groups}{acs_5yr}(ac)
}
\arguments{
\item{ac}{An \code{acs_5yr} object.}
}
\value{
A vector, area group names.
}
\description{
Gets the names of the Demographic and Economic Area Groups where data is available.
}
\examples{

dir <- system.file("extdata/acs_5yr", package = "geogenr")
ac <- acs_5yr(dir)

groups <- ac |>
  get_area_groups()

}
\seealso{
Other data download functions: 
\code{\link{acs_5yr}()},
\code{\link{download_selected_files}()},
\code{\link{get_area_file_names}()},
\code{\link{get_area_years}()},
\code{\link{get_areas}()},
\code{\link{get_selected_file_names}()},
\code{\link{get_too_heavy_file_names}()},
\code{\link{select_area_files}()},
\code{\link{unzip_files}()}
}
\concept{data download functions}
