% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodist-vec.R
\name{geodist_vec}
\alias{geodist_vec}
\title{geodist_vec}
\usage{
geodist_vec(
  x1,
  y1,
  x2,
  y2,
  paired = FALSE,
  sequential = FALSE,
  pad = FALSE,
  measure = "cheap"
)
}
\arguments{
\item{x1}{Numeric vector of longitude coordinates}

\item{y1}{Numeric vector of latitude coordinates}

\item{x2}{Optional second numeric vector of longitude coordinates}

\item{y2}{Optional second numeric vector of latitude coordinates}

\item{paired}{If \code{TRUE}, calculate paired distances between each entry
in \code{(x1, y1)} and \code{(x2, y2)}, returning a single vector.}

\item{sequential}{If \code{TRUE}, calculate (vector of) distances
sequentially along \code{(x1, y1)} (when no \code{(x2, y2)} are passed),
otherwise calculate matrix of pairwise distances between all points.}

\item{pad}{If \code{sequential = TRUE} values are padded with initial
\code{NA} to return \code{n} values for inputs of lenght \code{n}, otherwise
return \code{n - 1} values.}

\item{measure}{One of "haversine" "vincenty", "geodesic", or "cheap"
specifying desired method of geodesic distance calculation; see Notes.}
}
\value{
If only \code{(x1, y1)} are passed and \code{sequential = FALSE}, a
square symmetric matrix containing distances between all items in \code{(x1,
y1)}; If only \code{(x1, y1)} are passed and \code{sequential = TRUE}, a
vector of sequential distances between matching elements of \code{(x1, y1)};
otherwise if \code{(x2, y2)} are passed, a matrix of \code{lenght(x1) ==
length(y1)} rows and \code{length(x2) == length(y2)} columns.
}
\description{
An alternative interface to the main \link{geodist} function that directly
accepts inputs as individual vectors of coordinates, rather than the matrix
or `data.frame` inputs of the main function. This interface is provided for
cases where computational efficiency is important, and will generally provide
faster results than the main function.
}
\note{
\code{measure = "cheap"} denotes the mapbox cheap ruler
\url{https://github.com/mapbox/cheap-ruler-cpp}; \code{measure = "geodesic"}
denotes the very accurate geodesic methods given in Karney (2013)
"Algorithms for geodesics" J Geod 87:43-55, and as provided by the 
code{sf::st_dist()} function.
}
\examples{
n <- 50
# Default "cheap" distance measure is only accurate for short distances:
x1 <- -1 + 2 * runif (n, -0.1, 0.1)
y1 <- -1 + 2 * runif (n, -0.1, 0.1)
d0 <- geodist_vec (x1, y1) # A 50-by-50 matrix
d2 <- geodist_vec (x1, y1, sequential = TRUE) # Vector of length 49
d2 <- geodist_vec (x1, y1, sequential = TRUE, pad = TRUE) # Vector of length 50
x2 <- -10 + 20 * runif (2 * n, -0.1, 0.1)
y2 <- -10 + 20 * runif (2 * n, -0.1, 0.1)
d1 <- geodist_vec (x1, y1, x2, y2) # A 50-by-100 matrix
}
