% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodimension_complete_relation_by_geography.R
\name{complete_relation_by_geography}
\alias{complete_relation_by_geography}
\alias{complete_relation_by_geography.geodimension}
\title{Complete relation by geography}
\usage{
complete_relation_by_geography(
  gd,
  lower_level_name = NULL,
  upper_level_name = NULL
)

\method{complete_relation_by_geography}{geodimension}(
  gd,
  lower_level_name = NULL,
  upper_level_name = NULL
)
}
\arguments{
\item{gd}{A \code{geodimension} object.}

\item{lower_level_name}{A string, name of the lower level.}

\item{upper_level_name}{A string, name of the upper lever.}
}
\value{
A \code{geodimension} object.
}
\description{
Two levels can be related by attributes or by geography (if the upper level
has polygon-type geometry). Once related, if there are unrelated instances,
you can try to relate those instances using this function, which considers
alternative geographic relationships.
}
\details{
For example, if the lower level has associated point and polygon geometries,
only point geometry is considered to establish the initial relationship.
Polygon geometry is also considered in this function.

It does not necessarily succeed trying to relate the instances.
}
\examples{
ui <- gd_us |>
  get_unrelated_instances(lower_level_name = "state",
                          upper_level_name = "division")

gd <- gd_us |>
  complete_relation_by_geography(lower_level_name = "state",
                          upper_level_name = "division")

}
\seealso{
Other level association functions: 
\code{\link{add_level}()},
\code{\link{geodimension}()},
\code{\link{get_unrelated_instances}()},
\code{\link{relate_levels}()}
}
\concept{level association functions}
