% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_municipal_seat.R
\name{read_municipal_seat}
\alias{read_municipal_seat}
\title{Download spatial data of municipal seats (sede dos municipios) in Brazil}
\usage{
read_municipal_seat(year = 2010, showProgress = TRUE)
}
\arguments{
\item{year}{A year number in YYYY format. Defaults to \code{2010}}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar}
}
\value{
An \verb{"sf" "data.frame"} object
}
\description{
This function reads the official data on the municipal seats (sede dos municipios)
of Brazil. The data brings the geographical coordinates (lat lon) of municipal
seats for various years between 1872 and 2010. Original data were generated by
Brazilian Institute of Geography and Statistics (IBGE).
}
\examples{
\dontrun{ if (interactive()) {
# Read municipal seats in an specific year
m <- read_municipal_seat(year = 1991)
}}
}
