% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_statistical_grid.R
\name{read_statistical_grid}
\alias{read_statistical_grid}
\title{Download shape files of IBGE's statistical grid (200 x 200 meters) as sf objects. Data at scale 1:250,000, using Geodetic reference system "SIRGAS2000" and CRS(4674)}
\usage{
read_statistical_grid(code_grid, year = 2010, showProgress = TRUE)
}
\arguments{
\item{code_grid}{The 7-digit code of a grid quadrant If the two-letter abbreviation of a state is used,
the function will load all grid quadrants that intersect with that state. If code_grid="all", the grid of the whole country will be loaded.}

\item{year}{Year of the data (defaults to 2010). The only year available thus far is 2010.}

\item{showProgress}{Logical. Defaults to (TRUE) display progress bar}
}
\description{
Download shape files of IBGE's statistical grid (200 x 200 meters) as sf objects. Data at scale 1:250,000, using Geodetic reference system "SIRGAS2000" and CRS(4674)
}
\examples{
\dontrun{

library(geobr)

# Read specific municipality at a given year
  grid <- read_statistical_grid(code_grid = 45, year=2010)

# Read all municipalities of a state at a given year
  state_grid <- read_statistical_grid(code_grid = "RJ")

}
}
\seealso{
Other general area functions: 
\code{\link{read_amazon}()},
\code{\link{read_biomes}()},
\code{\link{read_census_tract}()},
\code{\link{read_conservation_units}()},
\code{\link{read_country}()},
\code{\link{read_health_region}()},
\code{\link{read_immediate_region}()},
\code{\link{read_intermediate_region}()},
\code{\link{read_meso_region}()},
\code{\link{read_micro_region}()},
\code{\link{read_municipality}()},
\code{\link{read_neighborhood}()},
\code{\link{read_region}()},
\code{\link{read_semiarid}()},
\code{\link{read_state}()},
\code{\link{read_weighting_area}()}
}
\concept{general area functions}
