% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\docType{methods}
\name{spc.plot}
\alias{spc.plot}
\alias{spc.plot,Spectra-method}
\title{Plotting \code{Spectra} object}
\usage{
spc.plot(x, Y, maxSp, lab_cex,xlab,ylab,type,pch,lwd,cex,...)

\S4method{spc.plot}{Spectra}(x, Y, maxSp, lab_cex, xlab, ylab, type = "l",
  pch = 19, lwd = 2, cex = 0.3, ...)
}
\arguments{
\item{x}{and Y     a \code{Spectra} data}

\item{Y}{fskjldsk}

\item{maxSp}{maximum number of \code{Spectra} to plot}

\item{lab_cex}{vector of character expansion sizes, used cyclically}

\item{xlab}{title for x  axix, as in plot().}

\item{ylab}{title for y axis, as in plot().}

\item{type}{character string (length 1 vector) or vector of 1-character strings indicating 
the type of plot for each column of y. See help of matplot() or plot().}

\item{pch}{character string or vector of 1-characters or integers for plotting characters.
See help of \code{\link{par}}.}

\item{lwd}{vector of line widths. See help of \code{\link{par}}.}

\item{cex}{A numerical value giving the amount by which plotting text and symbols should 
be magnified relative to the default. See help of \code{\link{par}}.}

\item{...}{any further arguments to be passed to matplot}
}
\description{
Generating plot of the intensity of a measurement inside a \code{Spectra} object with respect to the wavelength.
}
\examples{
x <- spc.example_spectra()
spc.plot(x)

}
\seealso{
\code{\link{spc.lines}}, \code{\link{par}}
}
