% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/geoinside.R
\name{geoinside}
\alias{geoinside}
\title{Finds a subset of a given set of data which is inside a given region.}
\usage{
geoinside(data, reg, option = 1, col.names = c("lat", "lon"), na.rm = T,
  robust = F)
}
\arguments{
\item{data}{a dataframe, should include vectors \$lat and \$lon, but will
except other names, see col.names.}

\item{reg}{The region we want to determine whether the data is inside of,
should include vectors with same names as data.}

\item{option}{Allows you to determine on what format you recieve the output:
<s-example> option = 1: returns the submatrix of data which is inside reg.
option = 2: returns the submatrix of data which is outside reg.  option = 3:
returns a boolean vector saying whether a given index is inside reg.  option
= 4: returns a boolean vector saying whether a give index is outside reg.
option = 5: returns a vector of indexes to data, data[return[i],] is the
i-th point in data inside reg.  option = 6: returns a vector of indexes to
data, data[return[i],] is the i-th point in data outside reg. </s-example>}

\item{col.names}{Default col.names = c("lat","lon"), determines the names of
the base vectors of the space we are viewing.  May be replaced by for
instance col.names = c("x","y")}

\item{na.rm}{If true values where \$lat or \$lon are NA are removed.
Default is false.}

\item{robust}{If true a robust search is done, if false the function runs
faster.  Default is true. Robust = T will not work if the regions edges
overlap each other, if region is sensibly defined this will not happen and
robust =F should be used.}
}
\value{
Returns and output vector or matrix, see option.
}
\description{
Finds a subset of a given set of data which is inside or outside a given
region and returns a submatrix of those values, boolean vector of indexes or
index vector.
}
\section{Side Effects}{
 None.
}
\examples{
\dontrun{   seafishing <- geoinside(fishing,island,option=2)
   # Removes those datapoints from fishing where fishing took
   # place inside Iceland (misspells).

   grd <- list(lat=c(64,64,63,63),lon=c(-23,-22,-22,-23))
   ins.lat.64.63.lon.23.22 <- geoinside(fishing,grd,robust =T)
   # Extracts those points from fishing where fishing
   # took place inside the given box.



   #######################################################
   # Example                                             #
   #######################################################

   par(mfrow=c(2,1))
   stations<-data.frame(lat=stodvar$lat,lon=stodvar$lon)
   stations<-stations[!is.na(stations$lon),]
   stations<-stations[!is.na(stations$lat),]

   geoplot(grid=F)
   geopoints(stations,pch=".",col=25)
   title(main="Before geoinside")

   sea.stations <- geoinside(stations,island,option=2)
   # Removes those datapoints from stations where
   # measurments took place inside Iceland (misspells).

   geoplot(grid=F)
   geopoints(sea.stations,pch=".",col=25)
   title(main="After geoinside")

   #######################################################

}
}
\seealso{
\code{\link{geoplot}}, \code{\link{geolocator}}.
}

