% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathways.R
\name{pathways_suggest}
\alias{pathways_suggest}
\title{Suggest Pathway Matches Based on Query Values}
\usage{
pathways_suggest(queryValues, options = list())
}
\arguments{
\item{queryValues}{A character vector representing the search terms or values to find
corresponding pathways.}

\item{options}{A list of options to customize the API request, including the API
endpoint URL, api_key, timeout duration, and user-agent string, with sensible defaults
set for querying the Genular pathways suggestion endpoint.}
}
\value{
A list containing suggested pathway matches including their identifiers and
other relevant details based on the provided query values.
}
\description{
This function queries the Genular API to suggest pathway matches based on an array
of query values. It is useful for identifying pathways related to specific terms
or concepts provided in the query.
}
\examples{
queryValues <- c("apoptosis", "signal transduction")
pathway_suggest_results <- pathways_suggest(queryValues)
print(pathway_suggest_results)
}
