% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_gen.R
\name{naiveSearch_bin}
\alias{naiveSearch_bin}
\title{Finds the index of the bin a number belongs to using naive search.}
\usage{
naiveSearch_bin(arr, x)
}
\arguments{
\item{arr}{A vector of size at least 2.}

\item{x}{A number. Must be within the range of [\code{arr[1]}, \code{arr[length(arr)]}].}
}
\value{
The index \code{i} such that \code{arr[i] <= x <= arr[i+1]}.
}
\description{
Finds the index of the bin a number belongs to using naive search.
}
\details{
Finds the smallest index \code{i} such that \code{arr[i] <= x <= arr[i+1]}.
}
\examples{
naiveSearch_bin(1:10, seq(1, 10, by=0.5))
}
