% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_size_function.R
\name{ss.calc}
\alias{ss.calc}
\title{Function to Calculate Sample Size}
\usage{
ss.calc(
  power = 0.8,
  Case.Rate = NULL,
  k = NULL,
  MAF = NULL,
  OR = NULL,
  Alpha = 0.05,
  True.Model = "All",
  Test.Model = "All"
)
}
\arguments{
\item{power}{Vector of the desired power(s)}

\item{Case.Rate}{Vector of the proportion(s) of cases in the sample (cases/(cases + controls)).  Either k or Case.Rate must be specified.}

\item{k}{Vector of the number of controls per case. Either k or Case.Rate must be specified.}

\item{MAF}{Vector of minor allele frequencies}

\item{OR}{Vector of odds ratios to detect}

\item{Alpha}{the desired type 1 error rate(s)}

\item{True.Model}{A vector specifying the true underlying genetic model(s): 'Dominant', 'Additive', 'Recessive' or 'All'}

\item{Test.Model}{A vector specifying the assumed genetic model(s) used in testing: 'Dominant', 'Additive', 'Recessive' or 'All'}
}
\value{
A data frame including the total number of subjects required for all combinations of the specified parameters (Case.Rate, OR, Power, etc)
}
\description{
Calculates the necessary sample size to achieve the specified level of power to detect an odds ratio, OR, with type 1 error rate, Alpha
}
\examples{
ss <- ss.calc(power=0.8, Case.Rate=0.5, k=NULL,
   MAF=0.1, OR=3,Alpha=0.05,
   True.Model='All', Test.Model='All')

}
