% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genius_album.R
\name{genius_album}
\alias{genius_album}
\title{Retrieve song lyrics for an album}
\usage{
genius_album(artist = NULL, album = NULL, info = "simple")
}
\arguments{
\item{artist}{The quoted name of the artist. Spelling matters, capitalization does not.}

\item{album}{The quoted name of the album Spelling matters, capitalization does not.}

\item{info}{Return track level metadata. See details.}
}
\description{
Obtain the lyrics to an album in a tidy format.
}
\details{
The `info` argument returns additional columns to the returned tibble:
`"simple"` returns only the song lyrics.
`"title"` returns the track title and lyrics.
`"artist"` returns the lyrics and artist.
`"features"` returns the lyrics, song elements, and element artists.
`"all"` returns all of the above mentioned, plus appends the album name.
}
\examples{

\dontrun{
genius_album(artist = "Petal", album = "Comfort EP")
genius_album(artist = "Fit For A King", album = "Deathgrip", info = "all")
}

}
