# 2019-03-15 - genio 1.0.0.9000

* First GitHub release!  Includes `read_bim`, `read_fam`, `read_ind`, and `read_snp` functions.

# 2019-03-31 - genio 1.0.1.9000

* Added an efficient `write_bed` written in Rcpp and thoroughly tested against `BEDMatrix` package.

# 2019-04-01 - genio 1.0.2.9000

* Improved `write_bed` error message for invalid data, documentation.
* Extended `write_bed` tests.

# 2019-04-01 - genio 1.0.3.9000

* Added `write_fam`, `write_bim`, `write_ind`, `write_snp` functions.
* Refactored `read_*` code, updated docs and tests.

# 2019-04-02 - genio 1.0.4.9000

* Added `make_fam`, `make_bim`, and `write_plink` functions.
* Fixed `read_fam` bug (used to require phenotypes to be integers, now can be double numbers).
* Added `verbose` option to `write_bed`.

# 2019-04-05 - genio 1.0.5.9000

* `write_plink` now returns `NULL` **invisibly**.
* Added `require_files_plink`, `delete_files_plink`.
* Removed "Fatal: " prefix from stop messages.

# 2019-04-08 - genio 1.0.6.9000

* Added `ind_to_fam`, `sex_to_int`, `sex_to_char`.
* 2019-05-13: added ORCID to author info

# 2019-05-16 - genio 1.0.7.9000

* Added `read_bed` and `read_plink`!
  Now all Plink reading and writing operations are supported.
* Added package documentation summarizing main read and write functions.
* Added vignette comparing our BED reader and writer to those of `BEDMatrix`, `snpStats`, and `lfa`.

# 2019-05-21 - genio 1.0.8

* First CRAN submission
* Genotype matrix row and column names from BIM/FAM files
  * `read_plink` now includes row and column names automatically.
  * `read_bed` accepts either row and column names or just their numbers.
  * `write_plink` checks these row and column names against the BIM and FAM tables for consistency, if these are all present.
* Added memory estimation and comparisons sections to vignette.
* Windows debugging
  * Now BED writing is in binary mode, like reading already was.
  * Reduced comparisons to `BEDMatrix` in testing, since it leaves temporary files open and on Windows they do not get deleted and leave confusing error messages behind.

# 2019-05-24 - genio 1.0.9

* CRAN-requested edits, resubmission
  * DESCRIPTION edits
  * Changed examples, vignettes, and tests to write files to the default temporary directory.

# 2019-05-28 - genio 1.0.10

* CRAN submission follow ups, fixing issues that arose on other systems:
  * Added `include <cerrno>` to my cpp code.
  * Fixed a "heap buffer overflow" detected by valgrind that only occurred for data with fewer than 9 individuals (included many of my toy tests).
  * Edited a test within vignette to allow for small machine precision-level errors.

# 2019-07-22 - genio 1.0.11

* Added `read_phen` and `write_phen`, a phenotype format (very similar to Plink's FAM) used by GCTA and EMMAX.
* Now `write_plink` returns the data it wrote, invisibly as a list.
  Most useful for auto-generated data.

# 2019-08-05 - genio 1.0.11.9000

* Fixed a "buffer overflow" bug that occurred when input files started with "~/" on Unix systems.

# 2019-12-17 - genio 1.0.12

* Second CRAN submission
* Moved logo to `man/figures/`
* Minor Roxygen-related updates.

# 2020-05-21 - genio 1.0.13

* Added `tidy_kinship` to transform a square symmetric matrix into a long-format table that is easy to sort and add annotations to

# 2020-06-16 - genio 1.0.13.9000

* Added `read_grm` and `write_grm` to read and write GCTA's binary genetic relatedness matrix (GRM) format.
* Also added auxiliary functions `require_files_grm`, `delete_files_grm`, `require_files_phen`, and `delete_files_phen`.

# 2020-06-23 - genio 1.0.14.9000

* Improved error message in `validate_tab_generic`.

# 2020-07-03 - genio 1.0.15.9000

* Functions `write_plink`, `write_bed`, and `write_bim` now have `append` option, for writing extremely large files in parts.

# 2020-07-28 - genio 1.0.16.9000

* Added `write_eigenvec` and `read_eigenvec` to read and write Plink/GCTA eigenvector files.

# 2020-07-31 - genio 1.0.17.9000

* Added `count_lines`, uses C++ code (via Rcpp) to count file lines extremely quickly.
  Intended for counting numbers of individuals (from FAM and equivalent files) or numbers of loci (from BIM and equivalent files) when these files are extremely large and no other information is needed from those files.

# 2020-08-17 - genio 1.0.18.9000

* Function `read_eigenvec` added Plink 2 support via `comment` option, which by default now treats data after `#` as comments.
  This enables automatically parsing eigenvec files generated by Plink 2, whose header line starts with `#` (this header is ignored).
  Previously, parsing Plink 2 eigenvec files generated warnings and resulted in the first row being an additional row with all `NA` values.

# 2020-12-22 - genio 1.0.19.9000

* Function `read_bed` added a missing file check in R code.
  * A check in the underlying C++ code already existed, but it could suffer from a buffer overflow if the erroneous file path was very long.
    Such buffer overflows are now completely avoided.
* Vignette: Removed `lfa` comparison. 
  * My latest `lfa` fork doesn't have function `read.bed` anymore, previously the slowest and most memory-hungry competitor, which `genio::read_plink` was being compared to.

# 2021-02-16 - genio 1.0.20.9000

* Documentation updates: 
  - Added GRM examples to README and `genio` package doc
  - Clarified language and code examples throughout, normalized style (full conversion to roxygen markdown, including fixing some cases where old non-markdown notation did not work anymore)
  - Spellchecked package

# 2021-04-27 - genio 1.0.21.9000

- Added function `geno_to_char` to convert genotype numeric codes (allele dosages such as 0, 1, 2) into character codes such as 'A/A', 'A/G', 'G/G' (depending on locus).
- Added functions `read_matrix` and `write_matrix`, intended for admixture inference data.
- Fixed documentation for `read_bed`, which previously incorrectly stated that the numerical genotypes (allele dosages) counted alternative alleles (allele 2 in BIM table), whereas the truth is that they count reference alleles (allele 1).

# 2021-05-21 - genio 1.0.22.9000

- Function `count_lines` now returns value as integer instead of double (a very minor bug/annoyance fix).

# 2021-06-11 - genio 1.0.23

- 3rd CRAN submission
- Removed `lfa` from suggested packages (no connection anymore since `lfa` comparison was removed from vignette in version 1.0.19.9000).
- Fixed a dead link in the vignette.
- Removed "LazyData: true" from DESCRIPTION (to avoid a new "note" on R-devel).

