% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootGcLC.R
\name{bootGcLC}
\alias{bootGcLC}
\title{Compute vector of n999 nonlinear Granger causality paths}
\usage{
bootGcLC(x1, x2, px2 = 4, px1 = 4, pwanted = 4, ctrl = 0, n999 = 9)
}
\arguments{
\item{x1}{{The data vector x1}}

\item{x2}{{The data vector x2}}

\item{px2}{{number of lags of x2 in the data, default px2=4}}

\item{px1}{{number of lags of x1 in the data default px1=4}}

\item{pwanted}{{number of lags of both x2 and x1 wanted for 
Granger causal analysis, default =4}}

\item{ctrl}{{data matrix having control variable(s) if any}}

\item{n999}{{Number of bootstrap replications (default=9)}}
}
\value{
out {is  n999 X 3 matrix for 3 outputs of GcauseX12 resampled}
}
\description{
Maximum entropy bootstrap (meboot) package is used for statistical inference
The bootstrap output can be analyzed to estimate an approximate confidence
interval on sample-based direction of the causal path.
The LC in the function name stands for local constant.
Kernel regression np package options regtype="lc" for local constant, 
and bwmethod="cv.ls" for least squares-based bandwidth selection are fixed.
}
\note{
This computation is computer intensive and generally very slow. 
  It may be better to use this function
  it at a later stage in the investigation, after a preliminary 
  causal determination is already made. The 3 outputs of GauseX12 are
  two Rsquares and the difference between after subtracting the second
  from the first.  Col. 1 has (RsqX1onX2)
  Col.2 has (RsqX2onX1), and Col.3 has dif=(RsqX1onX2 -RsqX2onX1)
  Note that R-squares are always positive. 
  If dif>0, RsqX1onX2>RsqX2onX1, implying that x2 on RHS performs better
  that is, x2 --> x1 is the path, or x2 Granger-causes x1.
  If dif<0, x1 --> x2 holds. If dif is too close to zero,
  we may have bidirectional causality  x1 <--> x2. The proportion of
  resamples (out of n999) having dif<0 suggests level of confidence in
  the conclusion x1 --> x2.  The proportion of
  resamples (out of n999) having dif>0 suggests level of confidence in
  the conclusion x2 --> x1.
}
\examples{
\dontrun{
library(Ecdat);options(np.messages=FALSE);attach(data.frame(MoneyUS))
bootGcLC(y,m,n999=9) 
}
\dontrun{
library(lmtest); data(ChickEgg);attach(data.frame(ChickEgg))
b2=bootGcLC(x1=chicken,x2=egg,pwanted=3,px1=3,px2=3,n999=99)
}


}
\references{
Vinod, H. D. `Generalized Correlation and Kernel Causality with 
 Applications in Development Economics' in Communications in 
 Statistics -Simulation and Computation, 2015, 
 \doi{10.1080/03610918.2015.1122048}

Zheng, S., Shi, N.-Z., and Zhang, Z. (2012). Generalized measures 
 of correlation for asymmetry, nonlinearity, and beyond. 
 Journal of the American Statistical Association, vol. 107, pp. 1239-1252.

Vinod, H. D. and Lopez-de-Lacalle, J. (2009). 'Maximum entropy bootstrap
 for time series: The meboot R package.' Journal of Statistical Software,
 Vol. 29(5), pp. 1-19.

Vinod, H. D. Causal Paths and Exogeneity Tests 
in {Generalcorr} Package for Air Pollution and Monetary Policy 
(June 6, 2017). Available at SSRN: \url{https://www.ssrn.com/abstract=2982128}
}
\seealso{
See Also \code{\link{GcRsqX12c}}.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\concept{maximum entropy bootstrap}
