% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transID.R
\name{transId}
\alias{transId}
\title{Transform gene id among symbol, entrezid,  ensembl and uniprot.}
\usage{
transId(id, transTo, org = "hs", unique = FALSE, keepNA = FALSE)
}
\arguments{
\item{id}{Gene ids.}

\item{transTo}{Transform to what type. User could select one or more from
"symbol", "entrez", "ensembl" or "uniprot."}

\item{org}{Latin organism shortname from `ensOrg_name`. Default is human.}

\item{unique}{Logical, if one-to-many mapping occurs, only keep one record with fewest NA. Default is FALSE.}

\item{keepNA}{If some id has no match at all, keep it or not. Default is FALSE.}
}
\value{
A two-column data frame, first is input id and second is transformed id.
}
\description{
Transform gene id among symbol, entrezid,  ensembl and uniprot.
}
\examples{
\dontrun{
# example1:
transId(
  id = c("Cyp2c23", "Fhit", "Gal3st2b", "Trp53", "Tp53"),
  transTo = "ensembl", org = "mouse", keepNA = FALSE
)

## example2: input id with one-to-many mapping and fake one
transId(
  id = c("MMD2", "HBD", "RNR1", "TEC", "BCC7", "FAKEID", "TP53"),
  transTo = c("entrez","ensembl"), keepNA = TRUE
)

# example3: auto-recognize ensembl version number
transId('ENSG00000141510.11','symbol')
}

}
