% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEnrich.R
\name{plotEnrich}
\alias{plotEnrich}
\title{Dotplot for GO and KEGG enrichment analysis}
\usage{
plotEnrich(
  enrich_df,
  plot_type = c("bar", "dot"),
  xlab_type = c("FoldEnrich", "GeneRatio", "Count"),
  legend_type = c("p.adjust", "pvalue", "qvalue"),
  low_color = "red",
  high_color = "blue",
  show_item = 10,
  xlim_left = 0,
  xlim_right = NA,
  wrap_length = NULL,
  ...
)
}
\arguments{
\item{enrich_df}{`data.frame` of enrichment analysis result.}

\item{plot_type}{One of "bar" and "dot"}

\item{xlab_type}{X-axis label type, one of 'GeneRatio','Count','FoldEnrich'.}

\item{legend_type}{Stats legend type, one of "pvalue", "p.adjust", "qvalue".}

\item{low_color}{Legend color for low pvalue or qvalue, default is "red".}

\item{high_color}{Legend color for high pvalue or qvalue, default is "blue".}

\item{show_item}{Numeric, select top N rows to show, default is 10.}

\item{xlim_left}{X-axis left limit, default is 0.}

\item{xlim_right}{X-axis right limit, default is NA.}

\item{wrap_length}{Numeric, wrap text if longer than this length, default is NULL.}

\item{...}{other arguments transfer to `plot_theme` function}
}
\value{
A ggplot object
}
\description{
Dotplot for GO and KEGG enrichment analysis
}
\examples{
\dontrun{
library(ggplot2)
data(geneList, package = "genekitr")
id <- names(geneList)[1:100]
ego <- genGO(id,
  org = "human", ont = "bp", pvalueCutoff = 0.05,
  qvalueCutoff = 0.05, use_symbol = TRUE
)
plotEnrich(ego,plot_type = "dot")

plotEnrich(ego,plot_type = "bar")
}

}
