/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.yadas;

import gov.lanl.yadas.Likelihood;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;

public class MultivariateGaussian
implements Likelihood {
    public double compute(double[][] data) {
        double[][] other = new double[data.length - 2][];
        System.arraycopy(data, 2, other, 0, data.length - 2);
        return this.compute(data[0], data[1], other);
    }

    public double compute(double[] x, double[] mu, double[][] sigma) {
        int d = x.length;
        if (d != mu.length || d != sigma.length) {
            throw new IllegalArgumentException("All arguments need to be of equal length");
        }
        Array2DRowRealMatrix sigmaM = new Array2DRowRealMatrix(sigma);
        Array2DRowRealMatrix xM = new Array2DRowRealMatrix(x);
        Array2DRowRealMatrix muM = new Array2DRowRealMatrix(mu);
        Array2DRowRealMatrix dM = xM.subtract(muM);
        LUDecomposition sigmaD = new LUDecomposition(sigmaM, Double.MIN_NORMAL);
        try {
            RealMatrix sigmaInv = sigmaD.getSolver().getInverse();
            return -0.5 * (Math.log(Math.PI * 2) * (double)d + Math.log(sigmaD.getDeterminant()) + dM.transpose().multiply(sigmaInv).multiply(dM).getEntry(0, 0));
        }
        catch (RuntimeException e) {
            System.out.println(sigmaM);
            throw e;
        }
    }
}

