/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.model;

import com.jgoodies.binding.beans.Observable;
import java.beans.PropertyChangeListener;
import javax.xml.bind.annotation.XmlTransient;
import org.drugis.common.beans.ObserverManager;
import org.drugis.mtc.data.DataType;
import org.drugis.mtc.data.MeasurementData;
import org.drugis.mtc.model.Treatment;

public class Measurement
extends MeasurementData
implements Observable {
    public static final String PROPERTY_TREATMENT = "treatment";
    public static final String PROPERTY_MEAN = "mean";
    public static final String PROPERTY_STDDEV = "stdDev";
    public static final String PROPERTY_SAMPLESIZE = "sampleSize";
    public static final String PROPERTY_RESPONDERS = "responders";
    @XmlTransient
    ObserverManager d_obsManager = new ObserverManager(this);

    public Measurement(Treatment t, int responders, int sampleSize) {
        this(t);
        this.setResponders(responders);
        this.setSampleSize(sampleSize);
    }

    public Measurement(Treatment t, double mean, double stdDev, int sampleSize) {
        this(t);
        this.setMean(mean);
        this.setStdDev(stdDev);
        this.setSampleSize(sampleSize);
    }

    public Measurement(Treatment t) {
        this.setTreatment(t);
    }

    public Measurement() {
    }

    public Treatment getTreatment() {
        return (Treatment)super.getTreatment();
    }

    public void setTreatment(Object value) {
        this.setTreatment((Treatment)value);
    }

    public void setTreatment(Treatment newValue) {
        Treatment oldValue = this.getTreatment();
        super.setTreatment(newValue);
        this.d_obsManager.firePropertyChange(PROPERTY_TREATMENT, oldValue, newValue);
    }

    public void setMean(Double newValue) {
        Double oldValue = this.getMean();
        super.setMean(newValue);
        this.d_obsManager.firePropertyChange(PROPERTY_MEAN, oldValue, newValue);
    }

    public void setStdDev(Double newValue) {
        Double oldValue = this.getStdDev();
        super.setStdDev(newValue);
        this.d_obsManager.firePropertyChange(PROPERTY_STDDEV, oldValue, newValue);
    }

    public void setSampleSize(Integer newValue) {
        Integer oldValue = this.getSampleSize();
        super.setSampleSize(newValue);
        this.d_obsManager.firePropertyChange(PROPERTY_SAMPLESIZE, oldValue, newValue);
    }

    public void setResponders(Integer newValue) {
        Integer oldValue = this.getResponders();
        super.setResponders(newValue);
        this.d_obsManager.firePropertyChange(PROPERTY_RESPONDERS, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.d_obsManager.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.d_obsManager.removePropertyChangeListener(listener);
    }

    public Measurement restrict(DataType type) {
        Measurement m = new Measurement();
        m.setTreatment(this.getTreatment());
        switch (type) {
            case NONE: {
                break;
            }
            case RATE: {
                m.setSampleSize(this.getSampleSize());
                m.setResponders(this.getResponders());
                break;
            }
            case CONTINUOUS: {
                m.setMean(this.getMean());
                m.setStdDev(this.getStdDev());
                m.setSampleSize(this.getSampleSize());
            }
        }
        return m;
    }
}

