/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.threading.status;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.drugis.common.beans.AbstractObservable;
import org.drugis.common.threading.Task;
import org.drugis.common.threading.event.TaskProgressEvent;
import org.drugis.common.threading.status.TextProgressModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProgressModel
extends AbstractObservable
implements TextProgressModel {
    public static final String DONE_TEXT = "Done!";
    public static final String WAITING_TEXT = "waiting";
    public static final String FAILED_TEXT = "failed";
    public static final String ABORTED_TEXT = "Aborted";
    protected Task d_task;
    protected Double d_progress;
    protected boolean d_determinate;

    protected abstract Double calcProgress();

    protected abstract boolean calcDeterminate();

    protected double calcProgress(TaskProgressEvent evt) {
        return (double)evt.getIteration() / (double)evt.getTotalIterations();
    }

    @Override
    public boolean getDeterminate() {
        return this.d_determinate;
    }

    @Override
    public Double getProgress() {
        return this.d_progress;
    }

    String formatProgress(Double progress) {
        if (progress == null) {
            return "?";
        }
        Long round = Math.round(100.0 * progress);
        return round.toString() + "%";
    }

    @Override
    public String getText() {
        String taskName = this.d_task.toString();
        List<String> phaseStrings = this.getPhaseStrings();
        String phaseString = " (" + StringUtils.join(phaseStrings, ", ") + ")";
        if (!this.d_task.isStarted()) {
            return taskName + " (" + WAITING_TEXT + ")";
        }
        if (this.d_task.isFinished()) {
            return DONE_TEXT;
        }
        if (this.d_task.isFailed()) {
            return taskName + " " + FAILED_TEXT + ": " + this.d_task.getFailureCause().getMessage();
        }
        if (this.d_task.isAborted()) {
            return taskName + ": " + ABORTED_TEXT;
        }
        if (!phaseStrings.isEmpty()) {
            return taskName + phaseString;
        }
        return taskName + ": " + this.formatProgress(this.getDeterminate() ? this.d_progress : null);
    }

    protected abstract List<String> getPhaseStrings();

    protected void setProgress(Double progress) {
        Double oldValue = this.d_progress;
        this.d_progress = progress;
        this.firePropertyChange("progress", oldValue, this.d_progress);
        this.firePropertyChange("text", null, this.getText());
    }

    protected void setDeterminate(boolean determinate) {
        boolean oldValue = this.d_determinate;
        this.d_determinate = determinate;
        this.firePropertyChange("determinate", oldValue, this.d_determinate);
    }
}

