% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MphEM.R
\name{MphEM}
\alias{MphEM}
\title{Perform expectation-maximization algorithm to infer Vg and Ve values for a pair of traits.}
\usage{
MphEM(max_iter = 10000, max_prec = 1/1e+06, eval, X, Y, V_g, V_e,
  verbose_output = FALSE)
}
\arguments{
\item{max_iter}{maximum number of iterations for EM algorithm}

\item{max_prec}{maximum precision for EM algorithm}

\item{eval}{vector of eigenvalues from relatedness matrix decomposition}

\item{X}{design matrix. Typically contains founder allele dosages.}

\item{Y}{matrix of phenotype values}

\item{V_g}{genetic covariance matrix}

\item{V_e}{error covariance matrix}

\item{verbose_output}{logical indicating whether to output entire collection of intermediate values for all iterations. Default is FALSE.}
}
\value{
a list of lists. Length of list corresponds to number of EM iterations
}
\description{
Perform expectation-maximization algorithm to infer Vg and Ve values for a pair of traits.
}
