% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{MS}
\alias{MS}
\title{Multiple Sclerosis data}
\usage{
data(MS)
}
\description{
A \code{data.frame} with a design and proteomic data.
}
\details{
Data from biobank are analysed a study population of 101 patients, 37 were diagnosed with
multiple sclerosis, and 64 without multiple sclerosis. Of the patients without multiple
sclerosis, 50 were diagnosed with other neurological disorders and 14 were neurologically
healthy patients who had undergone spinal anaesthesia for orthopaedic surgery on the knee
or ankle, i.e. neurologically healthy controls. Unless otherwise stated, all the patients
without multiple sclerosis were considered as controls for this study. All patients with
multiple sclerosis had relapsing remitting multiple sclerosis. The proteome were obtained
on cerebrospinal fluid samples from all patients prior medical treatment for multiple
sclerosis. It was discovered the patients separated into two clusters, called group 1 and
group 2. This is utilised in the data analysis by considering the data as 2-way factorial
design with the two factors: MS and group both on two levels.
}
\examples{
data(MS)
str(MS)

}
\references{
* Opsahl, J.A. et al. Label-free analysis of human cerebrospinal fluid addressing various normalization strategies and revealing protein groups affected by multiple sclerosis. Proteomics 16, 1154-1165 (2016).

* Ellen Færgestad Mosleth, Christian Alexander Vedeler, Kristian Hovde Liland, Anette McLeod, Gerd Haga Bringland, Liesbeth Kroondijk, Frode Berven, Artem Lysenko, Christopher J. Rawlings, Karim El-Hajj Eid, Jill Anette Opsahl, Bjørn Tore Gjertsen, Kjell-Morten Myhr and Sonia Gavasso, Cerebrospinal fluid proteome shows disrupted neuronal development in multiple sclerosis. Scientific Reports – Nature 11(4087), (2021).
}
\author{
Ellen Færgestad Mosleth
}
