% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_history_ohlc.R
\name{coin_history_ohlc}
\alias{coin_history_ohlc}
\title{Historical OHLC price data}
\usage{
coin_history_ohlc(coin_id, vs_currency = "usd", days, max_attempts = 3)
}
\arguments{
\item{coin_id}{(character): ID of the coin of interest. An
up-to-date list of supported coins and their IDs can be retrieved
with the \code{\link[=supported_coins]{supported_coins()}} function.}

\item{vs_currency}{(character): name of the reference currency to
express the price in. An up-to-date list of supported reference currencies (both
fiat and cryptocurrencies) can be obtained with the \code{\link[=supported_currencies]{supported_currencies()}}
function. If an unsupported \code{vs_currency} is requested, the call will
fail with the respective error message.}

\item{days}{(numeric or \code{"max"}): number of days to look back. The only
acceptable values are 1, 7, 14, 30, 90, 180, 365 and \code{"max"}. Attempts to
assign any other values will fail with the corresponding error message.
If \code{days = "max"}, the entire available history will be retrieved.
Depending on the value of \code{days}, the time interval used to present the
data will differ - see "Details".}

\item{max_attempts}{(double, positive): specifies the
maximum number of attempts to call the CoinGecko API (e.g., if
the first call fails for some reason). Additional attempts are
implemented with an exponential backoff. Defaults to 3.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{timestamp} (POSIXct);
\item \code{coin_id} (character): same as the argument \code{coin_id};
\item \code{vs_currency} (character): same as the argument \code{vs_currency};
\item \code{price_open} (double): coin price in the beginning of a time interval;
\item \code{price_high} (double): highest coin price observed within a time interval;
\item \code{price_low} (double): lowest coin price observed within a time interval;
\item \code{price_close} (double): coin price in the end of a time interval.
}
}
\description{
Retrieves open-high-low-close price data for the last \emph{n} days
}
\details{
Granularity of the retrieved data
(i.e. \href{https://en.wikipedia.org/wiki/Open-high-low-close_chart}{candle}'s
body) depends on the value of \code{days} as follows:
\itemize{
\item 1 day: 30 minutes;
\item 7 - 30 days: 4 hours;
\item above 30: 4 days.
}

This function is based on the public
\href{https://www.coingecko.com/api/documentations/v3}{CoinGecko API},
which has a limit of 50 calls per minute. Please
keep this limit in mind when developing your applications.
}
\examples{
\donttest{
r <- coin_history_ohlc(
  coin_id = "cardano",
  vs_currency = "usd",
  days = 7
)
print(r)
}
}
