% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesu_gozh.R
\name{sesu_gozh}
\alias{sesu_gozh}
\title{comparison of size effects of spatial units based on GOZH}
\usage{
sesu_gozh(
  formula,
  datalist,
  su,
  cores = 1,
  strategy = 2L,
  increase_rate = 0.05,
  alpha = 0.95,
  ...
)
}
\arguments{
\item{formula}{A formula of comparison of size effects of spatial units.}

\item{datalist}{A list of \code{data.frame} or \code{tibble}.}

\item{su}{A vector of sizes of spatial units.}

\item{cores}{(optional) Positive integer (default is 1). When cores are greater than 1, use
multi-core parallel computing.}

\item{strategy}{(optional) Calculation strategies of Q statistics at different scales. Default
is \code{2L}, see \code{details} for more contents.}

\item{increase_rate}{(optional) The critical increase rate of the number of discretization.
Default is \verb{5\%}.}

\item{alpha}{(optional) Specifies the size of confidence level. Default is \code{0.95}.}

\item{...}{(optional) Other arguments passed to \code{rpart_disc()}.}
}
\value{
A list.
\describe{
\item{\code{sesu}}{a tibble representing size effects of spatial units}
\item{\code{optsu}}{optimal spatial unit}
\item{\code{strategy}}{the optimal analytical scale selection strategy}
\item{\code{increase_rate}}{the critical increase rate of q value}
}
}
\description{
Function for comparison of size effects of spatial units in spatial heterogeneity analysis based on
geographically optimal zones-based heterogeneity(GOZH) model.
}
\details{
When \code{strategy} is \code{1}, use the same process as \code{sesu_opgd()}.If not, all explanatory
variables are used to generate a unique Q statistic corresponding to the data in the
datalist based on \code{rpart_disc()} and \code{gd()}, and then \code{loess_optscale()}is used to
determine the optimal analysis scale.
}
\examples{
\dontrun{
## The following code takes a long time to run:
library(tidyverse)
fvcpath = "https://github.com/SpatLyu/rdevdata/raw/main/FVC.tif"
fvc = terra::rast(paste0("/vsicurl/",fvcpath))
fvc1000 = fvc \%>\%
  terra::as.data.frame(na.rm = T) \%>\%
  as_tibble()
fvc5000 = fvc \%>\%
  terra::aggregate(fact = 5) \%>\%
  terra::as.data.frame(na.rm = T) \%>\%
  as_tibble()
sesu_gozh(fvc ~ .,
          datalist = list(fvc1000,fvc5000),
          su = c(1000,5000),
          cores = 6)
}
}
\references{
Song, Y., Wang, J., Ge, Y. & Xu, C. (2020) An optimal parameters-based geographical detector
model enhances geographic characteristics of explanatory variables for spatial heterogeneity
analysis: Cases with different types of spatial data, GIScience & Remote Sensing, 57(5), 593-610.
doi: 10.1080/15481603.2020.1760434.

Luo, P., Song, Y., Huang, X., Ma, H., Liu, J., Yao, Y., & Meng, L. (2022). Identifying determinants of
spatio-temporal disparities in soil moisture of the Northern Hemisphere using a geographically optimal
zones-based heterogeneity model. ISPRS Journal of Photogrammetry and Remote Sensing:
Official Publication of the International Society for Photogrammetry and Remote Sensing (ISPRS), 185, 111–128.
https://doi.org/10.1016/j.isprsjprs.2022.01.009
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
