% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_predicate.R
\name{filter_predicate}
\alias{filter_predicate}
\title{Filter data cube pixels by a user-defined predicate on band values}
\usage{
filter_predicate(cube, pred)
}
\arguments{
\item{cube}{source data cube}

\item{pred}{predicate to be evaluated over all pixels}
}
\value{
a proxy data cube object
}
\description{
Create a proxy data cube, which evaluates a predicate over all pixels of a data cube. For all pixels that fulfill the predicate, the original
band values are returned. Other pixels are simply filled with NANs. The predicate may access band values by name.
}
\details{
gdalcubes uses and extends the \href{https://github.com/codeplea/tinyexpr}{tinyexpr library} to evaluate expressions in C / C++, you can look at the \href{https://github.com/codeplea/tinyexpr#functions-supported}{library documentation}
to see what kind of expressions you can execute. Pixel band values can be accessed by name.
}
\note{
This function returns a proxy object, i.e., it will not start any computations besides deriving the shape of the result.
}
\examples{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db")) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
v = cube_view(extent=list(left=388941.2, right=766552.4, 
              bottom=4345299, top=4744931, t0="2018-01", t1="2018-06"),
              srs="EPSG:32618", nx = 497, ny=526, dt="P1M")
L8.cube = raster_cube(L8.col, v) 
L8.cube = select_bands(L8.cube, c("B04", "B05")) 
L8.ndvi = apply_pixel(L8.cube, "(B05-B04)/(B05+B04)", "NDVI") 
L8.ndvi.filtered = filter_predicate(L8.ndvi, "NDVI > 0.5") 
L8.ndvi.filtered
}
