% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosaic_rasters.R
\name{mosaic_rasters}
\alias{mosaic_rasters}
\title{Mosaic raster files using GDAL Utilities}
\usage{
mosaic_rasters(
  gdalfile,
  dst_dataset,
  output.vrt = NULL,
  output_Raster = FALSE,
  separate = FALSE,
  trim_margins = NULL,
  gdalwarp_index = 1,
  gdalwarp_params = list(r = "near"),
  force_ot = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{gdalfile}{Character. Input files (as a character vector) or a wildcard search term (e.g. "*.tif")}

\item{dst_dataset}{Character. The destination file name.}

\item{output.vrt}{Character. Output VRT file.  If NULL a temporary .vrt file will be created.}

\item{output_Raster}{Logical. Return output dst_dataset as a RasterBrick?}

\item{separate}{Logical. (starting with GDAL 1.7.0) Place each input file into a separate stacked band.  Unlike gdalbuildvrt, the full stack is placed in the mosaic, not just the first band.}

\item{trim_margins}{Numeric. Pre-crop the input tiles by a fixed number of pixels before mosaicking.  Can be a single value or four values representing the left, top, right, and bottom margins, respectively.}

\item{gdalwarp_index}{Numeric. If gdalwarp_index is numeric, the value is used as the index of the gdalfile to match projections and resolutions against when file projections don't match.  The default = 1 (the first input file).}

\item{gdalwarp_params}{List.  Set gdalwarp parameters if input file projections don't match.  t_srs and tr set here will override those chosen by gdalwarp_index.  In general, the only thing you would set here is the resampling algorithm, which defaults to nearest neighbor ("near").}

\item{force_ot}{Character. ("Byte"/"Int16"/"UInt16"/"UInt32"/"Int32"/"Float32"/"Float64"/"CInt16"/"CInt32"/"CFloat32"/"CFloat64") Forces all bands to be the same datatype. This is helpful if you are using input files of different data types and output formats (e.g. GTiff) that don't support mixed datatypes.}

\item{verbose}{Logical. Enable verbose execution? Default is FALSE.}

\item{...}{Parameters to pass to \code{\link{gdalbuildvrt}} or \code{\link{gdal_translate}}.}
}
\value{
Either a list of NULLs or a list of RasterBricks depending on whether output_Raster is set to TRUE.
}
\description{
Mosaic raster files using GDAL Utilities
}
\details{
This function mosaics a set of input rasters (gdalfile) using parameters
found in \code{\link{gdalbuildvrt}} and subsequently exports the mosaic to 
an output file (dst_dataset) using parameters found in \code{\link{gdal_translate}}.  The user
can choose to preserve the intermediate output.vrt file, but in general this is not
needed.
}
\examples{
# We'll pre-check to make sure there is a valid GDAL install
# and that raster and rgdal are also installed.
# Note this isn't strictly neccessary, as executing the function will
# force a search for a valid GDAL install.
outdir <- tempdir()
gdal_setInstallation()
valid_install <- !is.null(getOption("gdalUtils_gdalPath"))
if(require(raster) && require(rgdal) && valid_install)
{
layer1 <- system.file("external/tahoe_lidar_bareearth.tif", package="gdalUtils")
layer2 <- system.file("external/tahoe_lidar_highesthit.tif", package="gdalUtils")
mosaic_rasters(gdalfile=c(layer1,layer2),dst_dataset=file.path(outdir,"test_mosaic.envi"),
		separate=TRUE,of="ENVI",verbose=TRUE)
gdalinfo("test_mosaic.envi")
}
}
\seealso{
\code{\link{gdalbuildvrt}}, \code{\link{gdal_translate}}
}
\author{
Jonathan A. Greenberg (\email{gdalUtils@estarcion.net})
}
