% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gbfs.R
\name{get_gbfs}
\alias{get_gbfs}
\title{Grab bikeshare data}
\usage{
get_gbfs(city, feeds = "all", directory = NULL, output = NULL)
}
\arguments{
\item{city}{A character string that can be matched to a city or a url to an 
active gbfs.json feed. See \code{get_gbfs_cities} for a current list of available cities.}

\item{feeds}{Optional. A character string specifying which feeds should be saved. 
Options are \code{"all"}, \code{"static"}, and \code{"dynamic"}.}

\item{directory}{Optional. Path to a folder (or folder to be created) where 
the feed will will be saved.}

\item{output}{Optional. The type of output method. By default, output method 
will be inferred from the \code{directory} argument. If \code{output = "save"}, 
the dataframes will be saved as .rds objects in the given folder. If 
\code{output = "return"}, the results will be returned as a named list of 
dataframes. Setting \code{output = "both"} will do both. If both are left
as NULL, the result will be returned and not saved to file.}
}
\value{
The output of this function depends on the arguments supplied to 
\code{output} and \code{directory}. Either a folder of .rds dataframes saved
at the given path, a returned named list of dataframes, or both.
The function will raise an error if the \code{directory} and \code{output} 
arguments seem to conflict.
}
\description{
\code{get_gbfs} grabs bikeshare data supplied in the General Bikeshare 
Feed Specification format for a given city. By default, the function returns
the results as a named list of dataframes, but to make accumulation of
datasets over time straightforward, the user can also save the results
as .Rds files that will be automatically row-binded.
 Metadata for each dataset can be found at:
\url{https://github.com/NABSA/gbfs/blob/master/gbfs.md}
}
\examples{
# grab all of the feeds released by memphis' 
# bikeshare program  and return them as a 
# named list of dataframes
\donttest{get_gbfs(city = "memphis")}

# if, rather than returning the data, we wanted to save it:
\donttest{get_gbfs(city = "memphis", directory = tempdir())}

# note that, usually, we'd supply a character string 
# (like "memphis", maybe,) to the directory argument 
# instead of `tempdir()`. 

# if we're having trouble specifying the correct feed,
# we can also supply the actual URL to the feed
\donttest{get_gbfs(city = "https://gbfs.bcycle.com/bcycle_memphis/gbfs.json")}
                   
# the examples above grab every feed that memphis releases.
# if, instead, we just wanted the dynamic feeds
\donttest{get_gbfs(city = "memphis", feeds = "dynamic")}
}
