% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f2st.R
\name{f2st}
\alias{f2st}
\title{Repeated stepwise selection of covariates}
\usage{
f2st(y,x,p0=0.01,nu=1,km=0,kmx=0,mx=21,kx=0,lm=9^9,sub=F,inr=T,xinr=F)
}
\arguments{
\item{y}{Dependent variable}

\item{x}{Covariates}

\item{p0}{The P-value cut-off}

\item{nu}{The order statistic of Gaussian covariates used for comparison}

\item{km}{The maximum number of included covariates at each stage irrespective of P-value}

\item{kmx}{The maximum number of included covariates at each stage for the given  P-value}

\item{mx}{The maximum number of covariates for an all subset search}

\item{kx}{The excluded covariates}

\item{lm}{The maximum number of linear approximations}

\item{sub}{Logical if TRUE choose the best subset}

\item{inr}{Logical if TRUE include intercept}

\item{xinr}{Logical if TRUE intercept already included}
}
\value{
pv In order, the number of linear approximation, the included covariates, the P-values, sum of squared residuals .
}
\description{
Repeated stepwise selection of covariates
}
\examples{
data(boston)
bostint<-fgeninter(boston[,1:13],2)[[1]]
a<-f2st(boston[,14],bostint)
}
