% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers_parallel.R
\name{wrappers_parallel}
\alias{wrappers_parallel}
\alias{wrapper_parallel_none}
\alias{wrapper_parallel_multicore}
\alias{wrapper_parallel_snow}
\title{Wrappers for Parallelization Functions}
\usage{
wrapper_parallel_none(run_num, run_fun, run_details, ...)

wrapper_parallel_multicore(run_num, run_fun, run_details, ...)

wrapper_parallel_snow(run_num, run_fun, run_details, ...)
}
\arguments{
\item{run_num}{A number of iterations.}

\item{run_fun}{A function to be computed.}

\item{run_details}{A list of variables used for computation.}

\item{...}{Additional arguments to be passed to the parallelization function.}
}
\value{
A list containing computed values.
}
\description{
Wrappers of common R parallelization functions.
Their purpose is to be passed as the \code{parallel_function} argument in the \code{\link[gasmodel:gas_bootstrap]{gas_bootstrap()}} function.
}
\section{Functions}{
\itemize{
\item \code{wrapper_parallel_none()}: Wrapper for function \code{\link[base:lapply]{base::lapply()}}.

\item \code{wrapper_parallel_multicore()}: Wrapper for parallelization function \code{\link[parallel:mclapply]{parallel::mclapply()}}.

\item \code{wrapper_parallel_snow()}: Wrapper for parallelization function \code{\link[parallel:mclapply]{parallel::parLapply()}}.

}}
\seealso{
\code{\link[gasmodel:gas_bootstrap]{gas_bootstrap()}}
\code{\link[gasmodel:wrappers_optim]{wrappers_optim}}
\code{\link[gasmodel:wrappers_hessian]{wrappers_hessian}}
}
