% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credential-function-registry.R
\name{cred_funs}
\alias{cred_funs}
\alias{cred_funs_list}
\alias{cred_funs_add}
\alias{cred_funs_set}
\alias{cred_funs_clear}
\alias{cred_funs_set_default}
\title{Credential function registry}
\usage{
cred_funs_list()

cred_funs_add(...)

cred_funs_set(ls)

cred_funs_clear()

cred_funs_set_default()
}
\arguments{
\item{...}{One or more functions with the right signature: its first argument
is named \code{scopes}, and it includes \code{...} as an argument.}

\item{ls}{A list of credential functions.}
}
\value{
A list of credential functions or \code{NULL}.
}
\description{
Functions to query or manipulate the registry of credential functions
consulted by \code{\link[=token_fetch]{token_fetch()}}.
}
\section{Functions}{
\itemize{
\item \code{cred_funs_list}: Get the list of registered credential functions.

\item \code{cred_funs_add}: Register one or more new credential fetching functions.
Function(s) are added to the \emph{front} of the list. So:\preformatted{* "First registered, last tried."
* "Last registered, first tried."
}

\item \code{cred_funs_set}: Register a list of credential fetching functions.

\item \code{cred_funs_clear}: Clear the credential function registry.

\item \code{cred_funs_set_default}: Reset the registry to the gargle default.
}}

\examples{
names(cred_funs_list())

creds_one <- function(scopes, ...) {}
cred_funs_add(creds_one)
cred_funs_add(one = creds_one)
cred_funs_add(one = creds_one, two = creds_one)
cred_funs_add(one = creds_one, creds_one)

# undo all of the above and return to default
cred_funs_set_default()
}
\seealso{
\code{\link[=token_fetch]{token_fetch()}}, which is where the registry is actually used.
}
