% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gapfill.R
\name{Array2Matrix}
\alias{Array2Matrix}
\title{Convert an Array with 4 Dimensions into a Matrix}
\usage{
Array2Matrix(a)
}
\arguments{
\item{a}{Array with 4 dimensions.}
}
\value{
A matrix. If \code{a} has the attribute \code{mp}, the transformed attribute is returned as well.
See \code{\link{ArrayAround}} for more information about \code{mp}.
}
\description{
Converts the array, \code{a}, with 4 dimensions, \code{c(d1, d2, d3, d4)},
into a matrix with \code{d1*d2} rows and \code{d3*d4} columns.
}
\examples{
a <- array(data = 1:16, dim = c(2, 2, 2, 2))
Array2Matrix(a = a)
attr(a, "mp") <- c(1, 2, 2, 1)
Array2Matrix(a = a)

Array2Matrix(ArrayAround(data = a, mp = c(1, 1, 1, 1),
                         size = c(1, 1, 2, 2))) 
}
\author{
Florian Gerber, \email{florian.gerber@math.uzh.ch}.
}
\seealso{
\link{Index}, \code{\link{ArrayAround}}.
}

