% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequence-generics.R, R/Sequence-methods.R
\docType{methods}
\name{Sequence}
\alias{Sequence}
\alias{Later,.compoundExpr-method}
\alias{Then,.compoundExpr-method}
\alias{First,.compoundExpr-method}
\alias{Sequence,ANY-method}
\title{Sequence}
\usage{
Sequence(object, ..., negation, scope)

\S4method{Later}{.compoundExpr}(object)

\S4method{Then}{.compoundExpr}(object)

\S4method{First}{.compoundExpr}(object)

\S4method{Sequence}{ANY}(object, ..., negation, scope)
}
\arguments{
\item{object}{A sequence step or another expression that should be coerced to
a sequence condition.}

\item{...}{Other steps within the sequence condition, in the order in which
they should be applied.}

\item{negation}{Logical TRUE or FALSE to match segments where this sequence
has not occurred.}

\item{scope}{Optional scope, "users" or "sessions".}
}
\description{
Create a new gaSequence object
}
\section{Methods (by class)}{
\itemize{
\item \code{.compoundExpr}: Defines a sequence step using the supplied expression that does
not need to be immediately at the start nor immediately following any
preceding step.

\item \code{.compoundExpr}: Defines a sequential step using the supplied expression
that should immediately follow any preceding step or be the very first
required interaction in any sequences being matched to this sequential
segment definition.

\item \code{.compoundExpr}: Alias to Then.

\item \code{ANY}: Return a sequence of one or more steps using the
supplied expression(s) that define the steps, where those step can occur
anywhere within the sequences of interactions being matched, but in the
order specified.
}}

\examples{
expr1 <- Expr(~pagepath == "/")
expr2 <- Expr(~eventCategory == "video")
expr3 <- Expr(~timeOnPage > 10)
expr4 <- Expr(~transactionRevenue > 10)
expr5 <- expr1 & expr2
expr6 <- Expr(~eventAction == "click")
expr7 <- Expr(~eventCategory == "video") & Expr(~eventAction == "play")
expr8 <- Expr(~source == "google")
Segment(
  PerUser(
    expr1,        # treat an expression as 'condition type segment filter' by default
    PerHit(expr3)
  ),
  Sequence(
    expr2,
    Then(expr4),  # 'then' means 'immediately followed by'.
    Later(expr5)  # 'later' means 'followed by', but not necessarily immediately.
  ),
  Sequence(
    First(expr6), # First expressly means 'first interaction' within the date range.
    Then(expr7),  # By default, treat an expression within a sequence as happening
    expr8         # at any point after any preceding steps in the sequence, i.e. 'later'.
  )
)

}
\seealso{
Other sequence segment functions: \code{\link{First}},
  \code{\link{Later}}, \code{\link{Then}}
}
\concept{sequence segment functions}
