# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Write a data source to file
#'
#' Write a data source including settings of active columns to a file in binary format.
#' This file will be used as input in functions for generation of generative data.\cr
#'
#' @param outFileName Name of data source file
#'
#' @return None
#' 
#' 
#' 
#' @export
#'
#' @examples
#' \donttest{dsCreateWithDataFrame(dataFrame = iris)
#' dsDeactivateColumns(c(5))
#' dsWrite("iris4d.bin")}
dsWrite <- function(outFileName) {
    invisible(.Call('_ganGenerativeData_dsWrite', PACKAGE = 'ganGenerativeData', outFileName))
}

#' Read a data source from file
#'
#' Read a data source from a file in binary format
#'
#' @param inFileName Name of data source file
#'
#' @return None
#' @export
#'
#' @examples
#' \donttest{dsCreateWithDataFrame(dataFrame = iris)
#' dsDeactivateColumns(c(5))
#' dsWrite("iris4d.bin")
#' dsRead("iris4d.bin")}
dsRead <- function(inFileName) {
    invisible(.Call('_ganGenerativeData_dsRead', PACKAGE = 'ganGenerativeData', inFileName))
}

dsCreate <- function(columnTypes, columnNames) {
    invisible(.Call('_ganGenerativeData_dsCreate', PACKAGE = 'ganGenerativeData', columnTypes, columnNames))
}

dsAddValueRow <- function(valueVector) {
    invisible(.Call('_ganGenerativeData_dsAddValueRow', PACKAGE = 'ganGenerativeData', valueVector))
}

#' Deactivate columns
#'
#' Deactivate columns of a data source in order to exclude them in generation of generative data.
#' Note that in this version only columns with values of type double or float can be used in generation of generative data.
#' All columns with values of other type have to be deactivated.
#'
#' @param columnVector Vector of column indices
#'
#' @return None
#' @export
#'
#' @examples
#' \donttest{dsCreateWithDataFrame(dataFrame = iris)
#' dsDeactivateColumns(c(5))
#' dsGetInactiveColumnNames()}
dsDeactivateColumns <- function(columnVector) {
    invisible(.Call('_ganGenerativeData_dsDeactivateColumns', PACKAGE = 'ganGenerativeData', columnVector))
}

#' Activate columns
#'
#' Activate columns of a data source in order to include them in generation of generative data. By default columns are active.
#'
#' @param columnVector Vector of column indices
#'
#' @return None
#' @export
#'
#' @examples
#' \donttest{dsCreateWithDataFrame(dataFrame = iris)
#' dsGetActiveColumnNames()
#' dsDeactivateColumns(c(5))
#' dsGetActiveColumnNames()
#' dsActivateColumns(c(5))
#' dsGetActiveColumnNames()}
dsActivateColumns <- function(columnVector) {
    invisible(.Call('_ganGenerativeData_dsActivateColumns', PACKAGE = 'ganGenerativeData', columnVector))
}

#' Get active column names
#'
#' Get active column names of a data source
#'
#' 
#'
#' @return Vector of names of active columns
#' @export
#'
#' @examples
#' \donttest{dsCreateWithDataFrame(dataFrame = iris)
#' dsDeactivateColumns(c(5))
#' dsGetActiveColumnNames()}
dsGetActiveColumnNames <- function() {
    .Call('_ganGenerativeData_dsGetActiveColumnNames', PACKAGE = 'ganGenerativeData')
}

#' Get inactive column names
#'
#' Get inactive column names of a data source
#'
#' 
#'
#' @return Vector of names of inactive columns
#' @export
#'
#' @examples
#' \donttest{dsCreateWithDataFrame(dataFrame = iris)
#' dsDeactivateColumns(c(5))
#' dsGetInactiveColumnNames()}
dsGetInactiveColumnNames <- function() {
    .Call('_ganGenerativeData_dsGetInactiveColumnNames', PACKAGE = 'ganGenerativeData')
}

#' Get number of rows
#'
#' Get number of rows in a data source
#'
#' 
#'
#' @return Number of rows
#' @export
#'
#' @examples
#' \donttest{dsCreateWithDataFrame(dataFrame = iris)
#' dsGetNumberOfRows()}
dsGetNumberOfRows <- function() {
    .Call('_ganGenerativeData_dsGetNumberOfRows', PACKAGE = 'ganGenerativeData')
}

#' Get a row in a data source
#'
#' Get a row in a data source for a row index.
#'
#' @param index Index of row
#'
#' @return List containing row in data source
#' @export
#'
#' @examples
#' \donttest{dsCreateWithDataFrame(dataFrame = iris)
#' dsGetRow(1000)}
dsGetRow <- function(index) {
    .Call('_ganGenerativeData_dsGetRow', PACKAGE = 'ganGenerativeData', index)
}

dsGetNormalized <- function() {
    .Call('_ganGenerativeData_dsGetNormalized', PACKAGE = 'ganGenerativeData')
}

gdReset <- function() {
    invisible(.Call('_ganGenerativeData_gdReset', PACKAGE = 'ganGenerativeData'))
}

gdGetDataSourceFileName <- function() {
    .Call('_ganGenerativeData_gdGetDataSourceFileName', PACKAGE = 'ganGenerativeData')
}

gdGetGenerativeDataFileName <- function() {
    .Call('_ganGenerativeData_gdGetGenerativeDataFileName', PACKAGE = 'ganGenerativeData')
}

gdGetBatchSize <- function() {
    .Call('_ganGenerativeData_gdGetBatchSize', PACKAGE = 'ganGenerativeData')
}

gdGetMaxSize <- function() {
    .Call('_ganGenerativeData_gdGetMaxSize', PACKAGE = 'ganGenerativeData')
}

gdDataSourceRead <- function(inFileName) {
    invisible(.Call('_ganGenerativeData_gdDataSourceRead', PACKAGE = 'ganGenerativeData', inFileName))
}

gdGenerativeDataRead <- function(inFileName) {
    invisible(.Call('_ganGenerativeData_gdGenerativeDataRead', PACKAGE = 'ganGenerativeData', inFileName))
}

gdGenerativeDataWrite <- function(outFileName) {
    invisible(.Call('_ganGenerativeData_gdGenerativeDataWrite', PACKAGE = 'ganGenerativeData', outFileName))
}

gdCreateGenerativeData <- function() {
    invisible(.Call('_ganGenerativeData_gdCreateGenerativeData', PACKAGE = 'ganGenerativeData'))
}

gdDataSourceGetDataRandom <- function(rowCount) {
    .Call('_ganGenerativeData_gdDataSourceGetDataRandom', PACKAGE = 'ganGenerativeData', rowCount)
}

gdDataSourceGetNormalizedDataRandom <- function(rowCount) {
    .Call('_ganGenerativeData_gdDataSourceGetNormalizedDataRandom', PACKAGE = 'ganGenerativeData', rowCount)
}

gdGenerativeDataGetNormalizedDataRandom <- function(rowCount) {
    .Call('_ganGenerativeData_gdGenerativeDataGetNormalizedDataRandom', PACKAGE = 'ganGenerativeData', rowCount)
}

gdGenerativeDataGetDenormalizedDataRandom <- function(rowCount) {
    .Call('_ganGenerativeData_gdGenerativeDataGetDenormalizedDataRandom', PACKAGE = 'ganGenerativeData', rowCount)
}

gdGenerativeDataGetDenormalizedDataRandomWithDensities <- function(rowCount) {
    .Call('_ganGenerativeData_gdGenerativeDataGetDenormalizedDataRandomWithDensities', PACKAGE = 'ganGenerativeData', rowCount)
}

gdGetDataSourceDimension <- function() {
    .Call('_ganGenerativeData_gdGetDataSourceDimension', PACKAGE = 'ganGenerativeData')
}

gdAddValueRows <- function(valueRows) {
    invisible(.Call('_ganGenerativeData_gdAddValueRows', PACKAGE = 'ganGenerativeData', valueRows))
}

#' Get number of rows
#'
#' Get number of rows in generative data
#'
#' @return Number of rows
#' @export
#'
#' @examples
#' \donttest{gdRead("gd.bin")
#' gdGetNumberOfRows()}
gdGetNumberOfRows <- function() {
    .Call('_ganGenerativeData_gdGetNumberOfRows', PACKAGE = 'ganGenerativeData')
}

gdGetColumnNames <- function(indexVector) {
    .Call('_ganGenerativeData_gdGetColumnNames', PACKAGE = 'ganGenerativeData', indexVector)
}

gdGetGenerativeDataDimension <- function() {
    .Call('_ganGenerativeData_gdGetGenerativeDataDimension', PACKAGE = 'ganGenerativeData')
}

gdGetNumberVectorIndexNames <- function(numberVectorIndices) {
    .Call('_ganGenerativeData_gdGetNumberVectorIndexNames', PACKAGE = 'ganGenerativeData', numberVectorIndices)
}

#' Get a row in generative data
#'
#' Get a row in generative data for a row index
#'
#' @param index Index of row
#'
#' @return List containing row in generative data
#' @export
#'
#' @examples
#' \donttest{gdRead("gd.bin")
#' gdGetRow(1000)}
gdGetRow <- function(index) {
    .Call('_ganGenerativeData_gdGetRow', PACKAGE = 'ganGenerativeData', index)
}

gdGetMax <- function(i) {
    .Call('_ganGenerativeData_gdGetMax', PACKAGE = 'ganGenerativeData', i)
}

gdGetMin <- function(i) {
    .Call('_ganGenerativeData_gdGetMin', PACKAGE = 'ganGenerativeData', i)
}

gdIntCalculateDensityValues <- function() {
    invisible(.Call('_ganGenerativeData_gdIntCalculateDensityValues', PACKAGE = 'ganGenerativeData'))
}

#' Calculate density value for a data record
#' 
#' Calculate density value for a data record.
#'
#' @param dataRecord List containing a data record
#'
#' @return Normalized density value number
#' @export
#'
#' @examples
#' \donttest{gdRead("gd.bin")
#' gdCalculateDensityValue(List(6.1, 2.6, 5.6, 1.4))}
gdCalculateDensityValue <- function(dataRecord) {
    .Call('_ganGenerativeData_gdCalculateDensityValue', PACKAGE = 'ganGenerativeData', dataRecord)
}

#' Calculate density value quantile
#' 
#' Calculate density value quantile for a percent value. 
#'
#' @param percent Percent value
#'
#' @return Normalized density value quantile number
#' @export
#'
#' @examples
#' \donttest{gdRead("gd.bin")
#' gdCalculateDensityValueQuantile(50)}
gdCalculateDensityValueQuantile <- function(percent) {
    .Call('_ganGenerativeData_gdCalculateDensityValueQuantile', PACKAGE = 'ganGenerativeData', percent)
}

gdBuildFileName <- function(fileName, niveau) {
    .Call('_ganGenerativeData_gdBuildFileName', PACKAGE = 'ganGenerativeData', fileName, niveau)
}

