% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/signal_integrate.R
\docType{methods}
\name{signal_integrate}
\alias{signal_integrate}
\alias{signal_integrate-method}
\alias{signal_integrate,GammaSpectrum,missing-method}
\alias{signal_integrate,GammaSpectrum,GammaSpectrum-method}
\alias{signal_integrate,GammaSpectrum,numeric-method}
\alias{signal_integrate,GammaSpectra,missing-method}
\alias{signal_integrate,GammaSpectra,GammaSpectrum-method}
\alias{signal_integrate,GammaSpectra,numeric-method}
\title{Signal Integration}
\usage{
signal_integrate(object, background, ...)

\S4method{signal_integrate}{GammaSpectrum,missing}(object, range, energy = FALSE)

\S4method{signal_integrate}{GammaSpectrum,GammaSpectrum}(object, background, range, energy = FALSE)

\S4method{signal_integrate}{GammaSpectrum,numeric}(object, background, range, energy = FALSE)

\S4method{signal_integrate}{GammaSpectra,missing}(object, range, energy = FALSE, simplify = TRUE)

\S4method{signal_integrate}{GammaSpectra,GammaSpectrum}(object, background, range, energy = FALSE, simplify = TRUE)

\S4method{signal_integrate}{GammaSpectra,numeric}(object, background, range, energy = FALSE, simplify = TRUE)
}
\arguments{
\item{object}{A \linkS4class{GammaSpectrum} or \linkS4class{GammaSpectra}
object.}

\item{background}{A \linkS4class{GammaSpectrum} object.}

\item{...}{Currently not used.}

\item{range}{A length-two \code{\link{numeric}} vector giving the energy
range to integrate within (in keV).}

\item{energy}{A \code{\link{logical}} scalar: TODO?}

\item{simplify}{A \code{\link{logical}} scalar: should the result be
simplified to a matrix? The default value, \code{FALSE}, returns a list.}
}
\value{
If \code{simplify} is \code{FALSE} (the default) returns a
 \code{\link{list}} of numeric vectors (the signal value and its error),
 else returns a \code{\link{matrix}}.
}
\description{
Signal Integration
}
\details{
It assumes that each spectrum has an energy scale.
}
\references{
Guérin, G. & Mercier, M. (2011). Determining Gamma Dose Rates by Field Gamma
 Spectroscopy in Sedimentary Media: Results of Monte Carlo Simulations.
 \emph{Radiation Measurements}, 46(2), p. 190-195.
 \doi{10.1016/j.radmeas.2010.10.003}.

 Mercier, N. & Falguères, C. (2007). Field Gamma Dose-Rate Measurement with
 a NaI(Tl) Detector: Re-Evaluation of the "Threshold" Technique.
 \emph{Ancient TL}, 25(1), p. 1-4.
}
\seealso{
Other signal processing: 
\code{\link{baseline}},
\code{\link{peaks_find}()},
\code{\link{signal_slice}()},
\code{\link{signal_stabilize}()},
\code{\link{smooth}()}
}
\author{
N. Frerebeau
}
\concept{signal processing}
