% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpartErr.R
\name{rpartErr}
\alias{rpartErr}
\title{Calculate Error Rates for rpart model}
\usage{
rpartErr(train.rp, train, test, group = "type")
}
\arguments{
\item{train.rp}{Fitted lda model object.}

\item{train}{Training set data frame.}

\item{test}{Test set data frame.}

\item{group}{Factor that identifies groups}
}
\value{
Vector that holds training set error,
10-fold cross-validation error, and test set error
rates.
}
\description{
Given an rpart model object, calculate training set error,
10-fold cross-validation error, and test set error.
}
\examples{
\dontrun{
data(spam, package='kernlab')
spam[,-58] <- scale(spam[,-58])
nr <- sample(1:nrow(spam))
spam01 <- spam[nr[1:3601],]     ## Use for training,
## if holdout not needed
spam2 <- spam[nr[3602:4601],]   ## Test
spam01.rp <- rpart(type~., data=spam01, cp=0.0001)
rpRates <- rpartErr(train.rp=spam01.rp, train=spam01, test=spam2,
                    group='type')
}

}
