% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{post_results_records}
\alias{post_results_records}
\title{Upload Highbond Results - Records}
\usage{
post_results_records(
  auth,
  table_id,
  upload = NULL,
  purge = FALSE,
  skipquestions = FALSE,
  sizelimit = 75000
)
}
\arguments{
\item{auth}{Highbond authentication credentials, created from \code{\link{setup_highbond}}}

\item{table_id}{The table to be downloaded}

\item{upload}{A data frame to be uploaded. Classes supported are
c('character', 'numeric', 'logical', 'Date', 'POSIXct', 'POSIXlt')}

\item{purge}{FALSE by default. Whether or not to delete the contents of the table before overwriting.}

\item{skipquestions}{FALSE by default. Set TRUE if not purging and you don't want to overwrite the responses within the Results table already.}

\item{sizelimit}{75000 bytes (~75 kb) by default. Used to estimate chunk size. Reduce size if upload chunks tend to fail.}
}
\value{
No return value, although errors will be verbose
}
\description{
Uploads the content in to Highbond Results.
}
\details{
Current Results in the table can be purged or not. If data is not
purged, a check is performed that compatible types are being upload and all
fields exist. If purged, there will be no checks done beforehand, which may
alter structure of existing table.

If the Result table contains questionnaire responses, then any records that
are being updated may need to have the responses also included as well.
These fields are usually prefixed with a 'q'.

A result row is generally appended, however a Primary Key field within the
Data Analytic Settings for that table may be specified so a record with the
same primary key may be merged, rather than duplicated.
}
\examples{
\dontrun{
  upload <- data.frame(field_one = c('A','B','C'),
  field_two = c(1, 2, 3),
  field_three = c(10L, 11L, 12L),
  field_four = c(TRUE, FALSE, TRUE),
  field_five = c(as.Date('2019-01-01'), as.Date('2020-01-01'), as.Date('2021-12-31')),
  field_six = c(as.POSIXct(Sys.time()), as.POSIXct(Sys.time()), as.POSIXct(Sys.time())))
  post_results_records(auth, upload = upload, purge = TRUE)
  }
}
