% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.galamm}
\alias{coef.galamm}
\title{Extract galamm coefficients}
\usage{
\method{coef}{galamm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{galamm}, from \code{\link{galamm}}.}

\item{...}{Optional arguments passed on to other methods. Currently not used.}
}
\value{
A matrix with the requested coefficients.
}
\description{
Currently, this function only returns the fixed effects.
}
\examples{
# Poisson GLMM
count_mod <- galamm(
  formula = y ~ lbas * treat + lage + v4 + (1 | subj),
  data = epilep, family = poisson
)

# Extract coefficients
coef(count_mod)

}
\seealso{
\code{\link[=fixef.galamm]{fixef.galamm()}} for fixed effects, \code{\link[=ranef.galamm]{ranef.galamm()}} for random
effects, and \code{\link[=coef]{coef()}} for the generic function.

Other details of model fit: 
\code{\link{VarCorr}()},
\code{\link{confint.galamm}()},
\code{\link{deviance.galamm}()},
\code{\link{factor_loadings.galamm}()},
\code{\link{family.galamm}()},
\code{\link{fitted.galamm}()},
\code{\link{fixef}()},
\code{\link{formula.galamm}()},
\code{\link{llikAIC}()},
\code{\link{logLik.galamm}()},
\code{\link{nobs.galamm}()},
\code{\link{predict.galamm}()},
\code{\link{print.VarCorr.galamm}()},
\code{\link{ranef.galamm}()},
\code{\link{residuals.galamm}()},
\code{\link{response}()},
\code{\link{sigma.galamm}()},
\code{\link{vcov.galamm}()}
}
\concept{details of model fit}
