% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas_occurrences.R, R/atlas_counts.R,
%   R/atlas_species.R, R/atlas_media.R, R/atlas_taxonomy.R
\name{atlas_}
\alias{atlas_}
\alias{atlas_occurrences}
\alias{atlas_counts}
\alias{atlas_species}
\alias{atlas_media}
\alias{atlas_taxonomy}
\title{Retrieve a database query}
\usage{
atlas_occurrences(
  request = NULL,
  identify = NULL,
  filter = NULL,
  geolocate = NULL,
  data_profile = NULL,
  select = NULL,
  mint_doi = FALSE,
  doi = NULL,
  file = NULL
)

atlas_counts(
  request = NULL,
  identify = NULL,
  filter = NULL,
  geolocate = NULL,
  data_profile = NULL,
  group_by = NULL,
  limit = NULL,
  type = c("occurrences", "species")
)

atlas_species(
  request = NULL,
  identify = NULL,
  filter = NULL,
  geolocate = NULL,
  data_profile = NULL
)

atlas_media(
  request = NULL,
  identify = NULL,
  filter = NULL,
  select = NULL,
  geolocate = NULL,
  data_profile = NULL
)

atlas_taxonomy(
  request = NULL,
  identify = NULL,
  filter = NULL,
  constrain_ids = NULL
)
}
\arguments{
\item{request}{optional \code{data_request} object: generated by a call to
\code{\link[=galah_call]{galah_call()}}.}

\item{identify}{\code{tibble}: generated by a call to \code{\link[=galah_identify]{galah_identify()}}.}

\item{filter}{\code{tibble}: generated by a call to \code{\link[=galah_filter]{galah_filter()}}}

\item{geolocate}{\code{string}: generated by a call to \code{\link[=galah_geolocate]{galah_geolocate()}}}

\item{data_profile}{\code{string}: generated by a call to \code{\link[=galah_apply_profile]{galah_apply_profile()}}}

\item{select}{\code{tibble}: generated by a call to \code{\link[=galah_select]{galah_select()}}}

\item{mint_doi}{\code{logical}: by default no DOI will be generated. Set to
\code{TRUE} if you intend to use the data in a publication or similar.}

\item{doi}{\code{string}: (Optional) DOI to download. If provided overrides
all other arguments. Only available for the ALA.}

\item{file}{\code{string}: (Optional) file name. If not given, will be set to
\code{data} with date and time added. The file path (directory) is always given by
\code{galah_config()$package$directory}.}

\item{group_by}{\code{tibble}: generated by a call to \code{\link[=galah_group_by]{galah_group_by()}}.}

\item{limit}{\code{numeric}: maximum number of categories to return, defaulting to 100.
If limit is NULL, all results are returned. For some categories this will
take a while.}

\item{type}{\code{string}: one of \code{"occurrences"} or \code{"species"}.
Defaults to \code{"occurrences"}, which returns the number of records
that match the selected criteria; alternatively returns the number of
species. Formerly accepted arguments (\code{"records"} or \code{"species"}) are
deprecated but remain functional.}

\item{constrain_ids}{\code{string}: Optional string to limit which \code{taxon_concept_id}'s
are returned. This is useful for restricting taxonomy to particular
authoritative sources. Default is \code{"biodiversity.org.au"} for Australia,
which is the infix common to National Species List IDs; use
\code{NULL} to suppress source filtering. Regular expressions are supported.}
}
\value{
An object of class \code{tbl_df} and \code{data.frame} (aka a tibble). For
\code{atlas_occurrences()} and \code{atlas_species()}, this will have columns specified
by \code{\link[=select.data_request]{select()}}. For \code{atlas_counts()},
it will have columns specified by
\code{\link[=group_by.data_request]{group_by()}}.
}
\description{
An alternative to using \code{\link[=collect.data_request]{collect()}} at the
end of a query pipe is to call a function with the \code{atlas_} prefix. These
solutions are basically synonymous, but \code{atlas_} functions differ in two ways:
\itemize{
\item They have the ability to accept \code{filter}, \code{select} etc as arguments,
rather than within a pipe; but \strong{only} when using the \code{galah_} forms of
those functions (e.g. \code{\link[=galah_filter]{galah_filter()}}).
\item \code{atlas_} functions do not require you to specify the \code{method} or \code{type}
arguments to \code{\link[=galah_call]{galah_call()}}, as they are more specific in what data are
being requested.
}
}
\details{
Note that unless care is taken, some queries can be particularly large.
While most cases this will simply take a long time to process, if the number
of requested records is >50 million, the call will not return any data. Users
can test whether this threshold will be reached by first calling
\code{\link[=atlas_counts]{atlas_counts()}} using the same arguments that they intend to pass to
\code{atlas_occurrences()}. It may also be beneficial when requesting a large
number of records to show a progress bar by setting \code{verbose = TRUE} in
\code{\link[=galah_config]{galah_config()}}, or to use \code{compute()} to run the call before collecting
it later with \code{collect()}.
}
\examples{
\dontrun{
# Best practice is to first calculate the number of records
galah_call() |>
  filter(year == 2015) |>
  atlas_counts()

# Download occurrence records for a specific taxon
galah_config(email = "your_email_here") # login required for downloads
galah_call() |>
  identify("Reptilia") |>
  atlas_occurrences()

# Download occurrence records in a year range
galah_call() |>
  identify("Litoria") |>
  filter(year >= 2010 & year <= 2020) |>
  atlas_occurrences()
  
# Download occurrences records in a WKT-specified area
polygon <- "POLYGON((146.24960 -34.05930,
                     146.37045 -34.05930,
                     146.37045 -34.152549,
                     146.24960 -34.15254,
                     146.24960 -34.05930))"
galah_call() |> 
  identify("Reptilia") |>
  filter(year >= 2010, year <= 2020) |>
  st_crop(polygon) |>
  atlas_occurrences()
  
# Get a list of species within genus "Heleioporus"
# (every row is a species with associated taxonomic data)
galah_call() |>
  identify("Heleioporus") |>
  atlas_species()

# Download Regent Honeyeater records with multimedia attached
# Note this returns one row per multimedia file, NOT one per occurrence
galah_call() |>
  identify("Regent Honeyeater") |>
  filter(year == 2011) |>
  atlas_media()

# Get a taxonomic tree of *Chordata* down to the class level
galah_call() |> 
  identify("chordata") |>
  filter(rank == class) |>
  atlas_taxonomy()
}
}
\keyword{internal}
