% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_identifiers.R
\name{search_identifiers}
\alias{search_identifiers}
\title{Search for taxa with taxonomic identifiers}
\usage{
search_identifiers(query)
}
\arguments{
\item{query}{\code{string}: A vector containing one or more taxonomic
identifiers, given as strings.}
}
\value{
An object of class \code{tbl_df}, \code{data.frame} (aka a tibble) and \code{ala_id}
containing taxonomic information.
}
\description{
In the ALA, all records are associated with an identifier that uniquely
identifies the taxon to which that record belongs. Once those identifiers
are known, this function allows you to use them to look up further information
on the taxon in question. Effectively this is the inverse function to
\code{\link[=search_taxa]{search_taxa()}}, which takes names and provides identifiers. The resulting
\code{tibble} of taxonomic information can also be passed to \code{\link[=galah_identify]{galah_identify()}} to
filter queries to the specified taxon or taxa.
}
\examples{
# Look up a unique taxon identifier
search_identifiers(query = "https://id.biodiversity.org.au/node/apni/2914510")

}
\seealso{
\code{\link[=search_taxa]{search_taxa()}} for how to find species by (scientific) names.
\code{\link[=galah_identify]{galah_identify()}}, \code{\link[=galah_select]{galah_select()}}, \code{\link[=galah_filter]{galah_filter()}} and
\code{\link[=galah_geolocate]{galah_geolocate()}} for other ways to restrict the information returned
by \code{\link[=atlas_occurrences]{atlas_occurrences()}} and related functions.
}
