% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect_media.R
\name{collect_media}
\alias{collect_media}
\title{Collect media files}
\usage{
collect_media(
  df,
  type = c("full", "thumbnail"),
  path,
  download_dir,
  refresh_cache
)
}
\arguments{
\item{df}{tibble returned by \code{atlas_media()} or \code{show_all(media)}}

\item{type}{\code{string}: either \code{"full"} to download original images, or
\code{"thumbnail"} to download thumbnails}

\item{path}{\code{string}: path to directory where downloaded media will
be stored}

\item{download_dir}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{path} instead.}

\item{refresh_cache}{\code{logical}: if set to \code{TRUE} and
\code{galah_config(caching = TRUE)} then files cached from a previous query will
be replaced by the current query. NOTE: Unclear that this works right now.}
}
\value{
Available image & media files downloaded to a user local directory.
}
\description{
This function downloads full-sized or thumbnail images and media files using
information from \code{atlas_media} to a local directory.
}
\section{Examples}{


Use \code{atlas_media()} to return a \code{tibble} of records that contain media

\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_call() |> 
  galah_identify("perameles") |>
  galah_filter(year == 2015) |>
  atlas_media()
}\if{html}{\out{</div>}}

Then add \code{collect_media()} to the end of a query to download media files

\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_call() |> 
  galah_identify("perameles") |>
  galah_filter(year == 2015) |>
  atlas_media() |>
  collect_media(path = here::here("folder", "subfolder"))
}\if{html}{\out{</div>}}
}

