% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-topoSort.R
\name{graph-toposort}
\alias{graph-toposort}
\alias{topo_sort}
\alias{topo_sort.default}
\alias{topo_sortMAT}
\alias{topo_sort_vparList}
\title{Topological sort of vertices in directed acyclic graph}
\usage{
topo_sort(object, index = FALSE)

\method{topo_sort}{default}(object, index = FALSE)

topo_sortMAT(amat, index = FALSE)
}
\arguments{
\item{object}{An graph represented either as a \code{graphNEL}
object, an \code{igraph}, a (dense) \code{matrix}, a (sparse)
\code{dgCMatrix}.}

\item{index}{If FALSE, an ordering is returned if it exists and
\code{character(0)} otherwise. If TRUE, the index of the
variables in an adjacency matrix is returned and \code{-1}
otherwise.}

\item{amat}{Adjacency matrix.}
}
\value{
If FALSE, an ordering is returned if it exists and
    \code{character(0)} otherwise. If TRUE, the index of the
    variables in an adjacency matrix is returned and \code{-1}
    otherwise.
}
\description{
A topological ordering of a directed graph is a linear
    ordering of its vertices such that, for every edge (u->v), u
    comes before v in the ordering.  A topological ordering is
    possible if and only if the graph has no directed cycles, that
    is, if it is a directed acyclic graph (DAG). Any DAG has at
    least one topological ordering. Can hence be used for checking
    if a graph is a DAG.
}
\section{Note}{
 The workhorse is the \code{topo_sortMAT} function
    which takes an adjacency matrix as input
}

\examples{

dagMAT  <- dag(~a:b:c+c:d:e, result="matrix")
dagMATS <- as(dagMAT, "dgCMatrix")
dagNEL  <- as(dagMAT, "graphNEL")

topo_sort(dagMAT)
topo_sort(dagMATS)
topo_sort(dagNEL)

}
\seealso{
\code{\link{dag}}, \code{\link{ug}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
