% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-create-ugdag.R
\name{graph-create}
\alias{graph-create}
\alias{ug}
\alias{dag}
\alias{ugList}
\alias{dagList}
\alias{ugList2matrix}
\alias{ugList2dgCMatrix}
\alias{dagList2matrix}
\alias{dagList2dgCMatrix}
\title{Create undirected and directed graphs}
\usage{
ug(..., result = "graphNEL")

dag(..., result = "graphNEL", forceCheck = FALSE)
}
\arguments{
\item{\dots}{A generating class for a graph, see examples below}

\item{result}{The format of the graph. The possible choices are "graphNEL"
(for a graphNEL object), "matrix" (for an adjacency matrix), "dgCMatrix"
(for a sparse matrix), "igraph" (for an igraph object).}

\item{forceCheck}{Logical determining if it should be checked if the graph is
acyclical. Yes, one can specify graphs with cycles using the \code{dag()}
function.}
}
\value{
Functions \code{ug()}, and \code{dag()} can return a \code{graphNEL}
    object, a sparse or dense adjacency matrix or an \code{igraph} object.
}
\description{
These functions are wrappers for creation of graphs as
    implemented by graphNEL objects in the \code{graph} package.
}
\examples{

## The following specifications of undirected graphs are equivalent:
uG1 <- ug(~ a:b:c + c:d)
uG2 <- ug(c("a","b","c"), c("c","d"))
uG3 <- ug(c("a","b"), c("a","c"), c("b","c"), c("c","d"))

graph::edges(uG1)
graph::nodes(uG1)

## The following specifications of directed acyclig graphs are equivalent:
daG1 <- dag(~ a:b:c + b:c + c:d)
daG2 <- dag(c("a","b","c"), c("b","c"), c("c","d"))

graph::edges(daG1)
graph::nodes(daG2)

## dag() allows to specify directed graphs with cycles:
daG4 <- dag(~ a:b + b:c + c:a) # A directed graph but with cycles
## A check for acyclicity can be done with
## daG5 <- dag(~ a:b + b:c + c:a, forceCheck=TRUE) 

## A check for acyclicity is provided by topoSort
topo_sort( daG2 )
topo_sort( daG4 )

## Different representations
uG6 <- ug(~a:b:c + c:d, result="graphNEL")  # default
uG6
uG8 <- ug(~a:b:c + c:d, result="matrix")    # dense matrix
uG8
uG9 <- ug(~a:b:c + c:d, result="dgCMatrix") # sparse matrix
uG9

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
