% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{chest}
\alias{chest}
\alias{chest_cpt}
\title{Chest clinic example}
\format{An object of class \code{list} of length 8.}
\usage{
data(chest_cpt)
}
\description{
Conditional probability tables for the chest clinic example.
}
\examples{

## 'data' generated with the following code fragment
yn   <- c("yes", "no")
a    <- cptable(~asia, values=c(1,99),levels=yn)
t.a  <- cptable(~tub|asia, values=c(5,95,1,99),levels=yn)
s    <- cptable(~smoke, values=c(5,5), levels=yn)
l.s  <- cptable(~lung|smoke, values=c(1,9,1,99), levels=yn)
b.s  <- cptable(~bronc|smoke, values=c(6,4,3,7), levels=yn)
e.lt <- cptable(~either|lung:tub,values=c(1,0,1,0,1,0,0,1),levels=yn)
x.e  <- cptable(~xray|either, values=c(98,2,5,95), levels=yn)
d.be <- cptable(~dysp|bronc:either, values=c(9,1,7,3,8,2,1,9), levels=yn)

grain(compileCPT(a, t.a, s, l.s, b.s, e.lt, x.e, d.be))

# 'data' generated from
# chest_cpt <- list(a, t.a, s, l.s, b.s, e.lt, x.e, d.be)

data(chest_cpt)

}
\keyword{datasets}
