% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotPlane3D}
\alias{plotPlane3D}
\title{Plot a plane in 3D.}
\usage{
plotPlane3D(normal, point = NULL, offset = 0, ...)
}
\arguments{
\item{normal}{Normal to the plane.}

\item{point}{A point on the plane.}

\item{offset}{The offset of the plane (only used if \code{point = NULL}).}

\item{...}{Further arguments passed on the the rgl plotting functions. This must be done as
lists (see examples). Currently the following arguments are supported:
\itemize{
\item \code{argsPlanes3d}: A list of arguments for \link[rgl:planes3d]{rgl::planes3d}.
}}
}
\value{
NULL (invisible)
}
\description{
Plot a plane in 3D.
}
\examples{
ini3D(argsPlot3d = list(xlim = c(-1,10), ylim = c(-1,10), zlim = c(-1,10)) )
plotPlane3D(c(1,1,1), point = c(1,1,1))
plotPoints3D(c(1,1,1))
plotPlane3D(c(1,2,1), point = c(2,2,2), argsPlanes3d = list(col="red"))
plotPoints3D(c(2,2,2))
plotPlane3D(c(2,1,1), offset = -6, argsPlanes3d = list(col="blue"))
plotPlane3D(c(2,1,1), argsPlanes3d = list(col="green"))
finalize3D()
}
