% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/exampleGraphs.R
\name{exampleGraphs}
\alias{BauerEtAl2001}
\alias{BonferroniHolm}
\alias{BretzEtAl2009a}
\alias{BretzEtAl2009b}
\alias{BretzEtAl2009c}
\alias{BretzEtAl2011}
\alias{Entangled1Maurer2012}
\alias{Entangled2Maurer2012}
\alias{Ferber2011}
\alias{FerberTimeDose2011}
\alias{HommelEtAl2007}
\alias{HommelEtAl2007Simple}
\alias{HungEtWang2010}
\alias{HuqueAloshEtBhore2011}
\alias{MaurerEtAl1995}
\alias{WangTing2014}
\alias{cycleGraph}
\alias{exampleGraphs}
\alias{fallback}
\alias{fixedSequence}
\alias{generalSuccessive}
\alias{improvedFallbackI}
\alias{improvedFallbackII}
\alias{improvedParallelGatekeeping}
\alias{parallelGatekeeping}
\alias{simpleSuccessiveI}
\alias{simpleSuccessiveII}
\alias{truncatedHolm}
\title{Functions that create different example graphs}
\usage{
BonferroniHolm(n)

BretzEtAl2011()

BauerEtAl2001()

BretzEtAl2009a()

BretzEtAl2009b()

BretzEtAl2009c()

HommelEtAl2007()

HommelEtAl2007Simple()

parallelGatekeeping()

improvedParallelGatekeeping()

fallback(weights)

fixedSequence(n)

simpleSuccessiveI()

simpleSuccessiveII()

truncatedHolm(gamma)

generalSuccessive(weights = c(1/2, 1/2), gamma, delta)

HuqueAloshEtBhore2011()

HungEtWang2010(nu, tau, omega)

MaurerEtAl1995()

cycleGraph(nodes, weights)

improvedFallbackI(weights = rep(1/3, 3))

improvedFallbackII(weights = rep(1/3, 3))

FerberTimeDose2011(times, doses, w = "\\\\nu")

Ferber2011(w)

Entangled1Maurer2012()

Entangled2Maurer2012()

WangTing2014(nu, tau)
}
\arguments{
\item{n}{Number of hypotheses.}

\item{weights}{Numeric vector of node weights.}

\item{gamma}{An optional number in [0,1] specifying the value for variable gamma.}

\item{delta}{An optional number in [0,1] specifying the value for variable delta.}

\item{nu}{An optional number in [0,1] specifying the value for variable nu.}

\item{tau}{An optional number in [0,1] specifying the value for variable tau.}

\item{omega}{An optional number in [0,1] specifying the value for variable omega.}

\item{nodes}{Character vector of node names.}

\item{times}{Number of time points.}

\item{doses}{Number of dose levels.}

\item{w}{Further variable weight(s) in graph.}
}
\value{
A graph of class \code{\link{graphMCP}} that represents a
sequentially rejective multiple test procedure.
}
\description{
Functions that creates example graphs, e.g. graphs that represents a
Bonferroni-Holm adjustment, parallel gatekeeping or special procedures from
selected papers.
}
\details{
We are providing functions and not the resulting graphs directly because
this way you have additional examples: You can look at the function body
with \code{\link{body}} and see how the graph is built.

\describe{ \item{list("BonferroniHolm")}{ Returns a graph that represents a
Bonferroni-Holm adjustment.  The result is a complete graph, where all nodes
have the same weights and each edge weight is \eqn{\frac{1}{n-1}}{1/(n-1)}.
} \item{list("BretzEtAl2011")}{ Graph in figure 2 from Bretz et al. See
references (Bretz et al. 2011).  } \item{list("HommelEtAl2007")}{ Graph from
Hommel et al. See references (Hommel et al. 2007).  }
\item{list("parallelGatekeeping")}{ Graph for parallel gatekeeping. See
references (Dmitrienko et al. 2003).  }
\item{list("improvedParallelGatekeeping")}{ Graph for improved parallel
gatekeeping. See references (Hommel et al. 2007).  }
\item{list("HungEtWang2010")}{ Graph from Hung et Wang. See references (Hung
et Wang 2010).  } \item{list("MaurerEtAl1995")}{ Graph from Maurer et al.
See references (Maurer et al. 1995).  } \item{list("cycleGraph")}{ Cycle
graph. The weight \code{weights[i]} specifies the edge weight from node
\eqn{i}{i} to node \eqn{i+1}{i+1} for \eqn{i=1,\ldots,n-1}{i=1,...,n-1} and
\code{weight[n]} from node \eqn{n}{n} to node 1.  }
\item{list("improvedFallbackI")}{ Graph for the improved Fallback Procedure
by Wiens & Dmitrienko. See references (Wiens et Dmitrienko 2005).  }
\item{list("improvedFallbackII")}{ Graph for the improved Fallback Procedure
by Hommel & Bretz. See references (Hommel et Bretz 2008).  }
\item{list("Ferber2011")}{ Graph from Ferber et al. See references (Ferber
et al. 2011).  } \item{list("FerberTimeDose2011")}{ Graph from Ferber et al.
See references (Ferber et al. 2011).  } \item{list("Entangled1Maurer2012")}{
Entangled graph from Maurer et al. TODO: Add references as soon as they are
available.  } }
}
\examples{
g <- BonferroniHolm(5)

gMCP(g, pvalues=c(0.1, 0.2, 0.4, 0.4, 0.7))

HungEtWang2010()
HungEtWang2010(nu=1)
}
\author{
Kornelius Rohmeyer \email{rohmeyer@small-projects.de}
}
\references{
Holm, S. (1979). A simple sequentally rejective multiple test
procedure. Scandinavian Journal of Statistics 6, 65-70.

Dmitrienko, A., Offen, W., Westfall, P.H. (2003). Gatekeeping strategies for
clinical trials that do not require all primary effects to be significant.
Statistics in Medicine. 22, 2387-2400.

Bretz, F., Maurer, W., Brannath, W., Posch, M.: A graphical approach to
sequentially rejective multiple test procedures. Statistics in Medicine 2009
vol. 28 issue 4 page 586-604.
\url{http://www.meduniwien.ac.at/fwf_adaptive/papers/bretz_2009_22.pdf}

Bretz, F., Maurer, W. and Hommel, G. (2011), Test and power considerations
for multiple endpoint analyses using sequentially rejective graphical
procedures. Statistics in Medicine, 30: 1489--1501.

Hommel, G., Bretz, F. und Maurer, W. (2007). Powerful short-cuts for
multiple testing procedures with special reference to gatekeeping
strategies. Statistics in Medicine, 26(22), 4063-4073.

Hommel, G., Bretz, F. (2008): Aesthetics and power considerations in
multiple testing - a contradiction? Biometrical Journal 50:657-666.

Hung H.M.J., Wang S.-J. (2010). Challenges to multiple testing in clinical
trials. Biometrical Journal 52, 747-756.

W. Maurer, L. Hothorn, W. Lehmacher: Multiple comparisons in drug clinical
trials and preclinical assays: a-priori ordered hypotheses. In Biometrie in
der chemisch-pharmazeutischen Industrie, Vollmar J (ed.). Fischer Verlag:
Stuttgart, 1995; 3-18.

Maurer, W., & Bretz, F. (2013). Memory and other properties of multiple test
procedures generated by entangled graphs. Statistics in medicine, 32 (10), 1739-1753.

Wiens, B.L., Dmitrienko, A. (2005): The fallback procedure for evaluating a
single family of hypotheses. Journal of Biopharmaceutical Statistics
15:929-942.

Wang, B., Ting, N. (2014). An Application of Graphical Approach to
Construct Multiple Testing Procedures in a Hypothetical Phase III Design.
Frontiers in public health, 1 (75).

Ferber, G. Staner, L. and Boeijinga, P. (2011): Structured multiplicity and
confirmatory statistical analyses in pharmacodynamic studies using the
quantitative electroencephalogram, Journal of neuroscience methods, Volume
201, Issue 1, Pages 204-212.
}
\keyword{graphs}
\keyword{misc}

