/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.af.gMCP.gui.graph.LaTeXTool;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.power.PDialog;
import org.af.gMCP.gui.power.Scenario2;
import org.af.gMCP.gui.power.ScenarioPanelInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ScenarioPanel2
extends JPanel
implements ActionListener,
ScenarioPanelInterface {
    List<Scenario2> sc = new Vector<Scenario2>();
    JButton addScenario = new JButton("Add scenario");
    JButton rmScenario = new JButton("Remove last scenario");
    PDialog pd;
    JPanel panel = new JPanel();

    public ScenarioPanel2(PDialog pd) {
        this.pd = pd;
        this.sc.add(new Scenario2(pd, "Scenario " + (this.sc.size() + 1)));
        this.setUpLayout();
    }

    public void setUpLayout() {
        CellConstraints cc = new CellConstraints();
        int row = 2;
        String cols = "5dlu, fill:min:grow, pref, 5dlu, pref, 5dlu";
        String rows = "5dlu, fill:min:grow, 5dlu, pref, 5dlu";
        this.setLayout((LayoutManager)new FormLayout(cols, rows));
        this.add((Component)new JScrollPane(this.getMainPanel()), cc.xyw(2, row, 4));
        this.add((Component)this.addScenario, cc.xy(3, row += 2));
        this.add((Component)this.rmScenario, cc.xy(5, row));
        this.addScenario.addActionListener(this);
        this.rmScenario.addActionListener(this);
        this.rmScenario.setEnabled(false);
    }

    public JPanel getMainPanel() {
        this.panel.removeAll();
        CellConstraints cc = new CellConstraints();
        int row = 2;
        String cols = "5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu";
        for (Node n : this.pd.getNodes()) {
            cols = cols + ", fill:pref:grow, 5dlu";
        }
        for (Scenario2 s : this.sc) {
            rows = rows + ", pref, 5dlu";
        }
        this.panel.setLayout((LayoutManager)new FormLayout(cols, rows));
        int col = 2;
        this.panel.add((Component)new JLabel("Scenario name"), cc.xy(col, row));
        for (Node n : this.pd.nodes) {
            this.panel.add((Component)new JLabel(LaTeXTool.LaTeX2UTF(n.getName())), cc.xy(col += 2, row));
        }
        for (Scenario2 s : this.sc) {
            s.addComponents(this.panel, cc, row += 2);
        }
        return this.panel;
    }

    public String getNCPString() {
        return null;
    }

    public String getEffSizeString() {
        String sList = "list(";
        for (Scenario2 s : this.sc) {
            sList = sList + s.getEffSizeString() + ", ";
        }
        return sList.substring(0, sList.length() - 2) + ")";
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addScenario) {
            this.sc.add(new Scenario2(this.pd, "Scenario " + (this.sc.size() + 1)));
            this.getMainPanel();
            this.revalidate();
            this.repaint();
            this.rmScenario.setEnabled(true);
        } else if (e.getSource() == this.rmScenario) {
            if (this.sc.size() > 1) {
                this.sc.remove(this.sc.size() - 1);
                this.getMainPanel();
                this.revalidate();
                this.repaint();
            }
            if (this.sc.size() == 1) {
                this.rmScenario.setEnabled(false);
            }
        }
    }

    public Element getConfigNode(Document document) {
        Element e = document.createElement("scenarios");
        e.setAttribute("numberSC", "" + this.sc.size());
        e.setAttribute("numberHS", "" + this.sc.get((int)0).effSizes.size());
        for (Scenario2 s : this.sc) {
            e.appendChild(s.getConfigNode(document));
        }
        return e;
    }

    public void loadConfig(Element e) {
        int nSC = Integer.parseInt(e.getAttribute("numberSC"));
        int nHS = Integer.parseInt(e.getAttribute("numberHS"));
        while (this.sc.size() < nSC) {
            this.sc.add(new Scenario2(this.pd, "Scenario " + (this.sc.size() + 1)));
            this.rmScenario.setEnabled(true);
        }
        NodeList nlist = e.getChildNodes();
        for (int i = 0; i < this.sc.size(); ++i) {
            this.sc.get(i).loadConfig((Element)nlist.item(i));
        }
        this.getMainPanel();
        this.revalidate();
        this.repaint();
    }
}

