/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.af.gMCP.gui.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KoutofNDialog
extends JDialog
implements ActionListener {
    JButton ok = new JButton("Ok");
    JTextField howMany = new JTextField(5);
    List<JCheckBox> checkBox = new Vector<JCheckBox>();
    JLabel outOfN;
    int n;
    List<Node> nodes;

    public KoutofNDialog(JDialog parent, List<Node> nodes) {
        super(parent, "k out of n", true);
        this.setLocationRelativeTo(parent);
        this.nodes = nodes;
        String cols = "5dlu, pref, 5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu";
        for (Node n : nodes) {
            rows = rows + ", pref, 5dlu";
        }
        FormLayout layout = new FormLayout(cols, rows);
        this.getContentPane().setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.getContentPane().add((Component)new JLabel("At least"), cc.xy(2, row));
        this.getContentPane().add((Component)this.howMany, cc.xy(4, row));
        this.n = nodes.size();
        this.howMany.setText("" + (this.n - 1));
        this.outOfN = new JLabel("out of the following " + this.n + ":");
        this.getContentPane().add((Component)this.outOfN, cc.xy(6, row));
        row += 2;
        for (Node n : nodes) {
            JCheckBox jc = new JCheckBox(n.getName(), true);
            jc.addActionListener(this);
            this.checkBox.add(jc);
            this.getContentPane().add((Component)jc, cc.xyw(2, row, 7));
            row += 2;
        }
        this.getContentPane().add((Component)this.ok, cc.xy(8, row));
        this.ok.addActionListener(this);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i = this.checkBox.indexOf(e.getSource());
        if (i != -1) {
            this.n = 0;
            for (JCheckBox cb : this.checkBox) {
                if (!cb.isSelected()) continue;
                ++this.n;
            }
            this.outOfN.setText("out of the following " + this.n + ":");
        } else if (e.getSource() == this.ok) {
            if (this.n < 2) {
                JOptionPane.showMessageDialog(this, "Please select at least two hypotheses.", "Please select at least two hypotheses", 0);
                return;
            }
            this.dispose();
        }
    }

    public String getCommand() {
        if (this.n == this.nodes.size()) {
            return "sum(x)>=" + this.howMany.getText();
        }
        String s = "";
        for (int i = 0; i < this.checkBox.size(); ++i) {
            if (!this.checkBox.get(i).isSelected()) continue;
            s = s + (i + 1) + ",";
        }
        s = s.substring(0, s.length() - 1);
        return "sum(x[c(" + s + ")])>=" + this.howMany.getText();
    }
}

