% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampSize.R
\name{sampSizeCore}
\alias{sampSizeCore}
\title{Function for sample size calculation}
\usage{
sampSizeCore(upperN, lowerN = floor(upperN/2), targFunc, target,
  tol = 0.001, alRatio, Ntype = c("arm", "total"), verbose = FALSE, ...)
}
\arguments{
\item{upperN}{\code{targFunc(upperN)} should be bigger than target (otherwise \code{upperN} is doubled until this is the case).}

\item{lowerN}{\code{targFunc(lowerN)} should be smaller than target (otherwise \code{lowerN} is halfed until this is the case).}

\item{targFunc}{The target (power) function that should be monotonically increasing in \code{n}.}

\item{target}{The target value. The function searches the \code{n} with \code{targFunc(n)-target<tol} and \code{targFunc(n)>target}.}

\item{tol}{Tolerance: The function searches the \code{n} with \code{targFunc(n)-target<tol} and \code{targFunc(n)>target}.}

\item{alRatio}{Allocation ratio.}

\item{Ntype}{Either \code{"arm"} or \code{"total"}.}

\item{verbose}{Logical, whether verbose output should be printed.}

\item{...}{...}
}
\value{
Integer value \code{n} (of type numeric) with \code{targFunc(n)-target<tol} and \code{targFunc(n)>target}.
}
\description{
Function for sample size calculation
}
\details{
For details see the manual and examples.
}
\examples{

f <- function(x){1/100*log(x)}
gMCP:::sampSizeCore(upperN=1000, targFunc=f, target=0.008, verbose=TRUE, alRatio=1)

}
\author{
This function is taken from package DoseFinding under GPL from Bjoern Bornkamp, Jose Pinheiro and Frank Bretz
}

