/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Graphics2D;
import org.scilab.forge.jlatexmath.Box;

public class ScaleBox
extends Box {
    private Box box;
    private double xscl;
    private double yscl;

    public ScaleBox(Box b, double xscl, double yscl) {
        this.box = b;
        this.xscl = xscl;
        this.yscl = yscl;
        this.width = b.width * (float)Math.abs(xscl);
        this.height = yscl > 0.0 ? b.height * (float)yscl : -b.depth * (float)yscl;
        this.depth = yscl > 0.0 ? b.depth * (float)yscl : -b.height * (float)yscl;
        this.shift = b.shift * (float)yscl;
    }

    public void draw(Graphics2D g2, float x, float y) {
        this.drawDebug(g2, x, y);
        float dec = this.xscl < 0.0 ? this.width : 0.0f;
        g2.translate(x + dec, y);
        g2.scale(this.xscl, this.yscl);
        this.box.draw(g2, 0.0f, 0.0f);
        g2.scale(1.0 / this.xscl, 1.0 / this.yscl);
        g2.translate(-x - dec, -y);
    }

    public int getLastFontId() {
        return this.box.getLastFontId();
    }
}

