/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.config.Configuration;
import org.mutoss.gui.RControl;
import org.mutoss.gui.graph.Edge;
import org.mutoss.gui.graph.GraphMCP;
import org.mutoss.gui.graph.GraphView;
import org.mutoss.gui.graph.Node;
import org.mutoss.gui.graph.UpdateEdge;
import org.mutoss.gui.graph.UpdateNode;
import org.mutoss.gui.graph.VS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetList
extends JPanel
implements MouseMotionListener,
MouseListener {
    private static final Log logger = LogFactory.getLog(NetList.class);
    GraphView control;
    protected Vector<Edge> edges = new Vector();
    protected Vector<Node> nodes = new Vector();
    int drag = -1;
    int edrag = -1;
    Node firstVertex;
    boolean firstVertexSelected = false;
    public boolean testingStarted = false;
    JLabel statusBar;
    protected VS vs;
    public static String initialGraph = ".InitialGraph";

    public NetList(JLabel statusBar, VS vs, GraphView graphview) {
        this.statusBar = statusBar;
        this.vs = vs;
        this.control = graphview;
        vs.setNL(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        Font f = statusBar.getFont();
        statusBar.setFont(f.deriveFont(f.getStyle() ^ 1));
    }

    public void acceptNode(Node node) {
        this.control.getPView().savePValues();
        this.saveGraph(".tmpGraph", false);
        RControl.getR().eval(".tmpGraph <- rejectNode(.tmpGraph, \"" + node.getName() + "\")");
        this.reset();
        new GraphMCP(".tmpGraph", this.vs);
        this.control.getPView().restorePValues();
    }

    public void addDefaultNode(int x, int y) {
        this.addNode(new Node(this.nodes.size() + 1, "H" + (this.nodes.size() + 1), x, y, this.vs));
    }

    public void addEdge(Edge e) {
        Edge old = null;
        for (Edge e2 : this.edges) {
            if (e2.from == e.from && e2.to == e.to) {
                old = e2;
            }
            if (e2.from != e.to || e2.to != e.from) continue;
            e.curve = true;
            e2.curve = true;
        }
        if (old != null) {
            this.edges.remove(old);
        }
        this.edges.add(e);
        this.control.getDataTable().getModel().setValueAt(e.getW(), this.getKnoten().indexOf(e.from), this.getKnoten().indexOf(e.to));
    }

    public void addEdge(Node von, Node nach) {
        this.addEdge(von, nach, 1.0);
    }

    public void addEdge(Node von, Node nach, Double w) {
        Integer x = null;
        Integer y = null;
        boolean curve = false;
        for (Edge e : this.edges) {
            if (e.from != nach || e.to != von) continue;
            e.curve = true;
            curve = true;
        }
        for (int i = this.edges.size() - 1; i >= 0; --i) {
            if (this.edges.get((int)i).from != von || this.edges.get((int)i).to != nach) continue;
            x = this.edges.get(i).getK1();
            y = this.edges.get(i).getK2();
            this.edges.remove(i);
        }
        if (w != 0.0) {
            if (x != null) {
                this.edges.add(new Edge(von, nach, w, this.vs, x, y));
            } else {
                this.edges.add(new Edge(von, nach, w, this.vs, curve));
            }
            this.edges.lastElement().curve = curve;
        }
        this.control.getDataTable().getModel().setValueAt(w, this.getKnoten().indexOf(von), this.getKnoten().indexOf(nach));
    }

    public void addNode(Node node) {
        this.control.buttonStart.setEnabled(true);
        this.nodes.add(node);
        this.nodes.lastElement().fix = false;
        this.control.getPView().addPPanel(node);
        this.control.getDataTable().getModel().addRowCol(node.name);
        this.calculateSize();
    }

    public int[] calculateSize() {
        int i;
        int maxX = 0;
        int maxY = 0;
        for (i = 0; i < this.nodes.size(); ++i) {
            if (this.nodes.get(i).getX() > maxX) {
                maxX = this.nodes.get(i).getX();
            }
            if (this.nodes.get(i).getY() <= maxY) continue;
            maxY = this.nodes.get(i).getY();
        }
        for (i = 0; i < this.edges.size(); ++i) {
            if (this.edges.get(i).getK1() > maxX) {
                maxX = this.edges.get(i).getK1();
            }
            if (this.edges.get(i).getK2() <= maxY) continue;
            maxY = this.edges.get(i).getK2();
        }
        this.setPreferredSize(new Dimension((int)((double)(maxX + 2 * Node.getRadius() + 30) * this.vs.getZoom()), (int)((double)(maxY + 2 * Node.getRadius() + 30) * this.vs.getZoom())));
        this.revalidate();
        this.repaint();
        return new int[]{maxX, maxY};
    }

    public Edge findEdge(Node von, Node nach) {
        for (Edge e : this.edges) {
            if (von != e.from || nach != e.to) continue;
            return e;
        }
        return null;
    }

    public int[][] getAMatrix() {
        int i;
        int[][] e = new int[this.nodes.size()][];
        for (i = 0; i < this.nodes.size(); ++i) {
            e[i] = new int[this.nodes.size()];
            for (int j = 0; j < this.nodes.size(); ++j) {
                e[i][j] = 0;
            }
        }
        for (i = 0; i < this.edges.size(); ++i) {
            e[this.nodes.indexOf((Object)this.edges.get((int)i).from)][this.nodes.indexOf((Object)this.edges.get((int)i).to)] = 1;
            e[this.nodes.indexOf((Object)this.edges.get((int)i).to)][this.nodes.indexOf((Object)this.edges.get((int)i).from)] = 1;
        }
        return e;
    }

    public Vector<Edge> getEdges() {
        return this.edges;
    }

    public BufferedImage getImage() {
        long maxX = 0L;
        long maxY = 0L;
        for (Node node : this.nodes) {
            if ((long)node.getX() > maxX) {
                maxX = node.getX();
            }
            if ((long)node.getY() <= maxY) continue;
            maxY = node.getY();
        }
        for (Edge edge : this.edges) {
            if ((long)edge.getK1() > maxX) {
                maxX = edge.getK1();
            }
            if ((long)edge.getK2() <= maxY) continue;
            maxY = edge.getK2();
        }
        BufferedImage img = new BufferedImage((int)((double)(maxX + (long)(2 * Node.getRadius()) + 10L) * this.vs.getZoom()), (int)((double)(maxY + (long)(2 * Node.getRadius()) + 10L) * this.vs.getZoom()), 2);
        Graphics2D g = img.createGraphics();
        g.setStroke(new BasicStroke(Configuration.getInstance().getGeneralConfig().getLineWidth()));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (Node node : this.nodes) {
            node.paintYou(g);
        }
        for (Edge edge : this.edges) {
            edge.paintYou(g);
        }
        return img;
    }

    public Vector<Node> getKnoten() {
        return this.nodes;
    }

    public String getLaTeX() {
        int i;
        DecimalFormat format = Configuration.getInstance().getGeneralConfig().getDecFormat();
        String latex = "";
        double scale = 0.5;
        latex = latex + "\\begin{tikzpicture}[scale=" + scale + "]";
        for (i = 0; i < this.getKnoten().size(); ++i) {
            Node node = this.getKnoten().get(i);
            latex = latex + "\\node (" + node.getName().replace("_", "-") + ") at (" + node.getX() + "bp," + -node.getY() + "bp)\n";
            String nodeColor = "green!80";
            if (node.isRejected()) {
                nodeColor = "red!80";
            }
            latex = latex + "[draw,circle split,fill=" + nodeColor + "] {$" + node.getName() + "$ \\nodepart{lower} $" + format.format(node.getAlpha()) + "$};\n";
        }
        for (i = 0; i < this.getEdges().size(); ++i) {
            Node node1 = this.getEdges().get((int)i).from;
            Node node2 = this.getEdges().get((int)i).to;
            String to = "bend left=" + this.getEdges().get(i).getBendLeft();
            Double w = this.getEdges().get(i).getW();
            String weight = w.toString().equals("NaN") ? "$\\epsilon$" : "" + format.format(w);
            String pos = format.format(this.getEdges().get(i).getPos()).replace(",", ".");
            latex = latex + "\\draw [->,line width=1pt] (" + node1.getName().replace("_", "-") + ") to[" + to + "] node[pos=" + pos + ",above,fill=blue!20] {" + weight + "} (" + node2.getName().replace("_", "-") + ");\n";
        }
        latex = latex + "\\end{tikzpicture}\n\n";
        return latex;
    }

    public int getNodeNr(int id) throws Exception {
        for (int j = 0; j < this.nodes.size(); ++j) {
            if (this.nodes.get((int)j).nr != (long)id) continue;
            return j;
        }
        throw new Exception();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.drag == -1 && this.edrag == -1) {
            return;
        }
        if (this.drag != -1) {
            this.nodes.get(this.drag).setX((int)(((double)e.getX() - (double)Node.getRadius() * this.vs.getZoom()) / this.vs.getZoom()));
            this.nodes.get(this.drag).setY((int)(((double)e.getY() - (double)Node.getRadius() * this.vs.getZoom()) / this.vs.getZoom()));
        } else {
            this.edges.get(this.edrag).setK1((int)((double)e.getX() / this.vs.getZoom()));
            this.edges.get(this.edrag).setK2((int)((double)e.getY() / this.vs.getZoom()));
        }
        this.calculateSize();
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int i;
        logger.debug((Object)("MousePressed at (" + e.getX() + "," + e.getY() + ")."));
        if (this.vs.newVertex) {
            this.addDefaultNode((int)((double)e.getX() / this.vs.getZoom()) - Node.r, (int)((double)e.getY() / this.vs.getZoom()) - Node.r);
            this.vs.newVertex = false;
            this.statusBar.setText("Place new nodes and edges or start the test procedure");
            this.repaint();
            return;
        }
        if (this.vs.newEdge) {
            if (!this.firstVertexSelected) {
                this.firstVertex = this.vertexSelected(e.getX(), e.getY());
                if (this.firstVertex == null) {
                    return;
                }
                this.firstVertexSelected = true;
                this.statusBar.setText("Select a second node to which the edge should lead.");
            } else {
                Node secondVertex = this.vertexSelected(e.getX(), e.getY());
                if (secondVertex == null || secondVertex == this.firstVertex) {
                    return;
                }
                this.addEdge(this.firstVertex, secondVertex);
                this.vs.newEdge = false;
                this.firstVertexSelected = false;
                this.statusBar.setText("Place new nodes and edges or start the test procedure");
            }
            this.repaint();
            return;
        }
        if (this.drag == -1) {
            for (i = 0; i < this.nodes.size(); ++i) {
                if (!this.nodes.get(i).inYou(e.getX(), e.getY())) continue;
                this.drag = i;
            }
            if (this.drag != -1) {
                this.nodes.get((int)this.drag).drag = true;
            }
        }
        if (this.drag == -1 && this.edrag == -1) {
            for (i = 0; i < this.edges.size(); ++i) {
                if (!this.edges.get(i).inYou(e.getX(), e.getY())) continue;
                this.edrag = i;
            }
        }
        if (e.getClickCount() == 2 && !this.testingStarted) {
            for (i = 0; i < this.nodes.size(); ++i) {
                if (!this.nodes.get(i).inYou(e.getX(), e.getY())) continue;
                new UpdateNode(this.nodes.get(i), this);
            }
            for (i = 0; i < this.edges.size(); ++i) {
                if (!this.edges.get(i).inYou(e.getX(), e.getY())) continue;
                new UpdateEdge(this.edges.get(i), this, this.control);
            }
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.drag != -1) {
            this.nodes.get(this.drag).setX((int)(((double)e.getX() - (double)Node.getRadius() * this.vs.getZoom()) / this.vs.getZoom()));
            this.nodes.get(this.drag).setY((int)(((double)e.getY() - (double)Node.getRadius() * this.vs.getZoom()) / this.vs.getZoom()));
            this.calculateSize();
            this.nodes.get((int)this.drag).drag = false;
            this.drag = -1;
            this.repaint();
        }
        if (this.edrag != -1) {
            this.edges.get(this.edrag).setK1((int)((double)e.getX() / this.vs.getZoom()));
            this.edges.get(this.edrag).setK2((int)((double)e.getY() / this.vs.getZoom()));
            this.calculateSize();
            this.edrag = -1;
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int grid = Configuration.getInstance().getGeneralConfig().getGridSize();
        g.setColor(Color.LIGHT_GRAY);
        if (grid > 1) {
            for (int x = -Node.r / grid * grid; x < this.getWidth(); x += grid) {
                g.drawLine(x + Node.r, 0, x + Node.r, this.getHeight());
            }
            for (int y = -Node.r / grid * grid; y < this.getHeight(); y += grid) {
                g.drawLine(0, y + Node.r, this.getWidth(), y + Node.r);
            }
        }
        BasicStroke stroke = new BasicStroke(Configuration.getInstance().getGeneralConfig().getLineWidth());
        ((Graphics2D)g).setStroke(stroke);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (Node node : this.nodes) {
            node.paintYou(g);
        }
        for (Edge edge : this.edges) {
            edge.paintYou(g);
        }
    }

    public void refresh() {
        this.calculateSize();
        this.revalidate();
        this.repaint();
    }

    public void removeEdge(Edge edge) {
        for (Edge e : this.edges) {
            if (e.from != edge.to || e.to != edge.from) continue;
            e.curve = false;
        }
        this.edges.remove(edge);
    }

    public void removeNode(Node node) {
        for (int i = this.edges.size() - 1; i >= 0; --i) {
            Edge e = this.edges.get(i);
            if (e.from != node && e.to != node) continue;
            this.edges.remove(e);
        }
        this.control.getDataTable().getModel().delRowCol(this.getKnoten().indexOf(node));
        this.nodes.remove(node);
        this.control.getPView().removePPanel(node);
        if (this.nodes.size() == 0) {
            this.control.buttonStart.setEnabled(false);
        }
        this.repaint();
    }

    public void reset() {
        this.edges.removeAllElements();
        for (int i = this.getKnoten().size() - 1; i >= 0; --i) {
            this.removeNode(this.getKnoten().get(i));
        }
        this.statusBar.setText("Place new nodes and edges or start the test procedure");
        this.firstVertexSelected = false;
        this.vs.newVertex = false;
        this.vs.newEdge = false;
        this.vs.zoom = 1.0;
    }

    public void saveGraph(String graphName, boolean verbose) {
        int i;
        Node n2;
        graphName = RControl.getR().eval("make.names(\"" + graphName + "\")").asRChar().getData()[0];
        String alpha = "";
        String nodeStr = "";
        String x = "";
        String y = "";
        for (Node n2 : this.nodes) {
            alpha = alpha + n2.getAlpha() + ",";
            nodeStr = nodeStr + "\"" + n2.getName() + "\",";
            x = x + n2.getX() + ",";
            y = y + n2.getY() + ",";
        }
        alpha = alpha.substring(0, alpha.length() - 1);
        nodeStr = nodeStr.substring(0, nodeStr.length() - 1);
        x = x.substring(0, x.length() - 1);
        y = y.substring(0, y.length() - 1);
        RControl.getR().evalVoid(".gsrmtVar <- list()");
        RControl.getR().evalVoid(".gsrmtVar$alpha <- c(" + alpha + ")");
        RControl.getR().evalVoid(".gsrmtVar$hnodes <- c(" + nodeStr + ")");
        RControl.getR().evalVoid(".gsrmtVar$edges <- vector(\"list\", length=" + this.nodes.size() + ")");
        RControl.getR().evalVoid("names(.gsrmtVar$edges)<-.gsrmtVar$hnodes");
        for (i = this.nodes.size() - 1; i >= 0; --i) {
            n2 = this.nodes.get(i);
            String edgeL = "";
            String weights = "";
            for (Edge e : this.edges) {
                if (e.from != n2) continue;
                edgeL = edgeL + "\"" + e.to.getName() + "\",";
                weights = weights + (("" + e.getW()).equals("NaN") ? "0," : e.getW() + ",");
            }
            if (edgeL.length() != 0) {
                edgeL = edgeL.substring(0, edgeL.length() - 1);
                weights = weights.substring(0, weights.length() - 1);
                RControl.getR().evalVoid(".gsrmtVar$edges[[" + (i + 1) + "]] <- list(edges=c(" + edgeL + "), weights=c(" + weights + "))");
                continue;
            }
            RControl.getR().evalVoid(".gsrmtVar$edges[[" + (i + 1) + "]] <- list(edges=character(0), weights=numeric(0))");
        }
        RControl.getR().evalVoid(graphName + " <- new(\"graphMCP\", nodes=.gsrmtVar$hnodes, edgeL=.gsrmtVar$edges, alpha=.gsrmtVar$alpha)");
        RControl.getR().evalVoid(graphName + " <- gMCP:::stupidWorkAround(" + graphName + ")");
        for (i = this.nodes.size() - 1; i >= 0; --i) {
            n2 = this.nodes.get(i);
            if (!n2.isRejected()) continue;
            RControl.getR().evalVoid("nodeData(" + graphName + ", \"" + n2.getName() + "\", \"rejected\") <- TRUE");
        }
        RControl.getR().evalVoid(".gsrmtVar$nodeX <- c(" + x + ")");
        RControl.getR().evalVoid(".gsrmtVar$nodeY <- c(" + y + ")");
        RControl.getR().evalVoid("names(.gsrmtVar$nodeX) <- .gsrmtVar$hnodes");
        RControl.getR().evalVoid("names(.gsrmtVar$nodeY) <- .gsrmtVar$hnodes");
        RControl.getR().evalVoid("nodeRenderInfo(" + graphName + ") <- list(nodeX=.gsrmtVar$nodeX, nodeY=.gsrmtVar$nodeY)");
        for (Edge e : this.edges) {
            RControl.getR().evalVoid("edgeData(" + graphName + ", \"" + e.from.getName() + "\", \"" + e.to.getName() + "\", \"labelX\") <- " + (e.k1 - Node.getRadius()));
            RControl.getR().evalVoid("edgeData(" + graphName + ", \"" + e.from.getName() + "\", \"" + e.to.getName() + "\", \"labelY\") <- " + (e.k2 - Node.getRadius()));
        }
        if (verbose) {
            JOptionPane.showMessageDialog(null, "The graph as been exported to R under ther variable name:\n\n" + graphName, "Saved as \"" + graphName + "\"", 1);
        }
    }

    public void setEdges(Vector<Edge> edges) {
        this.edges = edges;
    }

    public void setKnoten(Vector<Node> knoten) {
        this.nodes = knoten;
    }

    public Node vertexSelected(int x, int y) {
        for (Node n : this.nodes) {
            if (!n.inYou(x, y)) continue;
            return n;
        }
        return null;
    }

    public void startTesting() {
        this.testingStarted = true;
        this.statusBar.setText("Reject nodes or reset to the initial graph for modifications.");
    }

    public void stopTesting() {
        this.testingStarted = false;
        this.statusBar.setText("Place new nodes and edges or start the test procedure");
    }

    public void saveGraph() {
        this.saveGraph(initialGraph, false);
        this.control.getPView().savePValues();
    }

    public void loadGraph() {
        new GraphMCP(initialGraph, this.vs);
        this.control.getPView().restorePValues();
    }

    public boolean isTesting() {
        return this.testingStarted;
    }
}

