/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.graph;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.af.commons.widgets.validate.RealTextField;
import org.af.commons.widgets.validate.ValidationException;
import org.mutoss.gui.RControl;
import org.mutoss.gui.graph.ControlMGraph;
import org.mutoss.gui.graph.NetzListe;
import org.mutoss.gui.graph.Node;

public class DialogConfIntEstVar
extends JDialog
implements ActionListener,
ChangeListener,
DocumentListener {
    List<JLabel> names = new Vector<JLabel>();
    List<JLabel> alpha = new Vector<JLabel>();
    List<JLabel> ci = new Vector<JLabel>();
    List<JSpinner> df = new Vector<JSpinner>();
    List<RealTextField> est = new Vector<RealTextField>();
    List<RealTextField> var = new Vector<RealTextField>();
    List<JComboBox> alt = new Vector<JComboBox>();
    List<JComboBox> dist = new Vector<JComboBox>();
    String[] dists = new String[]{"normal-distributed", "t-distributed"};
    String[] alternatives = new String[]{"two.sided", "less", "greater"};
    NetzListe nl;
    ControlMGraph control;
    DecimalFormat format = new DecimalFormat("#.####");

    public DialogConfIntEstVar(JFrame p, ControlMGraph control, NetzListe nl) {
        super((Frame)p, "Confidence intervals");
        this.setLocationRelativeTo(p);
        this.nl = nl;
        this.control = control;
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)new JScrollPane(this.getPanel()), c);
        c.fill = 1;
        ++c.gridy;
        JLabel label = new JLabel("Confidence Intervals:");
        this.getContentPane().add((Component)label, c);
        ++c.gridy;
        this.getContentPane().add((Component)new JScrollPane(this.getCIPanel()), c);
        ++c.gridy;
        c.weighty = 1.0;
        this.pack();
        this.setVisible(true);
    }

    private JPanel getCIPanel() {
        JPanel panel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.setLayout(new GridBagLayout());
        for (int i = 0; i < this.nl.getKnoten().size(); ++i) {
            Node node = this.nl.getKnoten().get(i);
            c.gridx = 0;
            JLabel hypothesis = new JLabel(node.getName() + ":");
            panel.add((Component)hypothesis, c);
            ++c.gridx;
            JLabel ci = new JLabel("]" + this.format.format(Double.NEGATIVE_INFINITY) + "," + this.format.format(Double.POSITIVE_INFINITY) + "[");
            this.ci.add(ci);
            panel.add((Component)ci, c);
            ++c.gridx;
            ++c.gridy;
        }
        this.calculateCI();
        return panel;
    }

    private void calculateCI() {
        String pValues = this.control.getPView().getPValuesString();
        double[] alpha = RControl.getR().eval("getAlpha(gMCP(" + NetzListe.initialGraph + "," + pValues + "))").asRNumeric().getData();
        for (int i = 0; i < this.nl.getKnoten().size(); ++i) {
            Double ub;
            Double lb;
            String d1 = "qnorm(";
            String d2 = ",)";
            if (this.dist.get(i).getSelectedItem().equals(this.dists[1])) {
                d1 = "qt(";
                d2 = "," + Integer.parseInt(this.df.get(i).getValue().toString()) + ")";
            }
            if (this.alt.get(i).getSelectedItem().equals("greater")) {
                lb = RControl.getR().eval(d1 + alpha[i] + d2).asRNumeric().getData()[0];
                ub = Double.POSITIVE_INFINITY;
            } else if (this.alt.get(i).getSelectedItem().equals("less")) {
                lb = Double.NEGATIVE_INFINITY;
                ub = RControl.getR().eval(d1 + (1.0 - alpha[i]) + d2).asRNumeric().getData()[0];
            } else {
                lb = RControl.getR().eval(d1 + alpha[i] / 2.0 + d2).asRNumeric().getData()[0];
                ub = RControl.getR().eval(d1 + (1.0 - alpha[i] / 2.0) + d2).asRNumeric().getData()[0];
            }
            try {
                Double ste = (Double)this.var.get(i).getValidatedValue();
                Double pEst = (Double)this.est.get(i).getValidatedValue();
                this.ci.get(i).setText("]" + this.format.format(pEst + lb * ste) + "," + this.format.format(pEst + ub * ste) + "[");
                continue;
            }
            catch (ValidationException e) {
                this.ci.get(i).setText("Please specify a real number for the estimate!");
            }
        }
    }

    public JPanel getPanel() {
        JPanel panel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.setLayout(new GridBagLayout());
        for (Node node : this.nl.getKnoten()) {
            c.gridx = 0;
            JLabel hypothesis = new JLabel(node.getName() + ":");
            this.names.add(hypothesis);
            panel.add((Component)hypothesis, c);
            ++c.gridx;
            JLabel alpha = new JLabel("\u03b1=" + this.format.format(node.getAlpha()));
            this.alpha.add(alpha);
            panel.add((Component)alpha, c);
            ++c.gridx;
            panel.add((Component)new JLabel("Estimate:"), c);
            ++c.gridx;
            RealTextField estimate = new RealTextField("Point estimate");
            estimate.setColumns(8);
            estimate.setText("0");
            estimate.getDocument().addDocumentListener(this);
            this.est.add(estimate);
            panel.add((Component)estimate, c);
            ++c.gridx;
            panel.add((Component)new JLabel("Standard error/deviation:"), c);
            ++c.gridx;
            RealTextField ste = new RealTextField("Standard error");
            ste.setColumns(8);
            ste.setText("1");
            ste.getDocument().addDocumentListener(this);
            this.var.add(ste);
            panel.add((Component)ste, c);
            ++c.gridx;
            JComboBox<String> dist = new JComboBox<String>(this.dists);
            dist.addActionListener(this);
            this.dist.add(dist);
            panel.add(dist, c);
            ++c.gridx;
            SpinnerNumberModel dfModel = new SpinnerNumberModel(9, 1, Integer.MAX_VALUE, 1);
            JSpinner df = new JSpinner(dfModel);
            ((JSpinner.DefaultEditor)df.getEditor()).getTextField().setColumns(4);
            df.setEnabled(dist.getSelectedItem().equals(this.dists[1]));
            this.df.add(df);
            df.addChangeListener(this);
            c.weightx = 0.0;
            panel.add((Component)df, c);
            c.weightx = 1.0;
            ++c.gridx;
            JComboBox<String> alt = new JComboBox<String>(this.alternatives);
            alt.addActionListener(this);
            this.alt.add(alt);
            panel.add(alt, c);
            ++c.gridx;
            ++c.gridy;
        }
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        int i = this.dist.indexOf(e.getSource());
        if (i != -1) {
            this.df.get(i).setEnabled(this.dist.get(i).getSelectedItem().equals(this.dists[1]));
        }
        this.calculateCI();
    }

    public void stateChanged(ChangeEvent e) {
        this.calculateCI();
    }

    public void changedUpdate(DocumentEvent e) {
        this.calculateCI();
    }

    public void insertUpdate(DocumentEvent e) {
        this.calculateCI();
    }

    public void removeUpdate(DocumentEvent e) {
        this.calculateCI();
    }
}

