/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.af.commons.Localizer;
import org.mutoss.config.Configuration;
import org.mutoss.gui.MenuBarMGraph;
import org.mutoss.gui.RControl;
import org.mutoss.gui.graph.ControlMGraph;
import org.mutoss.gui.graph.GraphMCP;
import org.mutoss.gui.graph.GraphView;
import org.mutoss.gui.graph.PView;

public class CreateGraphGUI
extends JFrame
implements WindowListener {
    GraphMCP graph;
    static String graphStr;
    static boolean debug;
    static double grid;
    JLabel statusbar = new JLabel();
    GraphView graphview;
    ControlMGraph agc;
    PView pview;

    public CreateGraphGUI(String graph, boolean debug, double grid) {
        super("Creating and modifying graphs");
        Locale.setDefault(Locale.ENGLISH);
        RControl.getRControl(debug);
        Localizer.getInstance().addResourceBundle("org.mutoss.gui.ResourceBundle");
        Configuration.getInstance().getGeneralConfig().setGridSize((int)grid);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/org/mutoss/gui/graph/images/rjavaicon64.png")).getImage());
        this.agc = new ControlMGraph(graph, this);
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 2);
        this.addWindowListener(this);
        this.setJMenuBar(new MenuBarMGraph(this.agc));
        this.makeContent();
        this.graph = new GraphMCP(graph, this.graphview.getVS());
        this.setVisible(true);
    }

    public static void startGUI(String graphStr, boolean debug, double grid) {
        CreateGraphGUI.graphStr = graphStr;
        CreateGraphGUI.debug = debug;
        CreateGraphGUI.grid = grid;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new CreateGraphGUI(graphStr, debug, grid);
            }
        });
    }

    private void makeContent() {
        this.graphview = new GraphView(this.agc);
        this.pview = new PView(this.agc);
        JSplitPane splitPane = new JSplitPane(1, this.graphview, this.pview);
        this.getContentPane().add(splitPane);
    }

    public static void main(String[] args) {
        new CreateGraphGUI("graph", true, 10.0);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public PView getPView() {
        return this.pview;
    }

    public GraphView getGraphView() {
        return this.graphview;
    }
}

